/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.dto.pipeline.PipelineDTO;
import com.digiwin.commons.entity.enums.DataCatalogClassificationType;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.ds.TDsAssetsOperationRecord;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.entity.vo.ds.ProcessDefinitionVO;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import feign.Request;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DataPipelineProcessor
extends DataAssetsBaseProcessor<PipelineDTO> {
    private static final Logger log = LoggerFactory.getLogger(DataPipelineProcessor.class);
    private final DsService dsService;

    @Override
    public void save(PipelineDTO pipelineDTO) {
        if (ObjectUtil.isNull((Object)pipelineDTO.getClassificationType()) || pipelineDTO.getClassificationType() != 2) {
            return;
        }
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(pipelineDTO.getId());
        dataAssetsVO.setName(pipelineDTO.getName());
        dataAssetsVO.setCreateTime(new Date());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_PIPELINE.getCode());
        dataAssetsVO.setProject(pipelineDTO.getProjectName());
        dataAssetsVO.setTenantId(pipelineDTO.getTenantId());
        String key = String.valueOf(pipelineDTO.getId()).concat("_").concat(DataCatalogClassificationType.DATA_PIPELINE.name());
        this.dataSaveEs(key, dataAssetsVO);
    }

    @Override
    public void bindCatalog(PipelineDTO pipelineDTO) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(pipelineDTO.getId()).catalogIds(pipelineDTO.getCatalogIds()).classificationType(DataCatalogClassificationType.DATA_PIPELINE.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void unbindCatalog(Object[] args) {
        Integer id = Integer.valueOf(String.valueOf(args[1]));
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(id).classificationType(DataCatalogClassificationType.DATA_PIPELINE.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    private void unbindCatalogById(Integer id) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(id).classificationType(DataCatalogClassificationType.DATA_PIPELINE.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void update(PipelineDTO pipelineDTO) {
        Object[] obj = new Object[3];
        obj[2] = pipelineDTO.getId();
        this.remove(obj);
        this.save(pipelineDTO);
    }

    @Override
    public void remove(Object obj) {
        Object[] args = (Object[])obj;
        String id = String.valueOf(args[1]).concat("_").concat(DataCatalogClassificationType.DATA_PIPELINE.name());
        this.dataRemoveEs(id);
        if (!ObjectUtils.isEmpty((Object)args[1])) {
            this.unbindCatalogById(Integer.valueOf(String.valueOf(args[1])));
        }
    }

    @Override
    public PipelineDTO getToEsArgs(Object ... dataParam) {
        UserInfo userInfo = UserInfoContext.getContext();
        Object[] args = (Object[])dataParam[0];
        PipelineDTO pipelineDTO = JSONUtils.parseObject(JSONUtils.toJson(args[1]), PipelineDTO.class);
        if (pipelineDTO.getId() == null || pipelineDTO.getId() == 0) {
            pipelineDTO.setId(this.getDataIdByResult(dataParam[1]));
        }
        pipelineDTO.setTenantId(userInfo.getTenantId());
        return pipelineDTO;
    }

    @Override
    public Integer getDataId(Object ... dataParam) {
        PipelineDTO pipelineDTO = this.getToEsArgs(dataParam);
        if (ObjectUtil.isNull((Object)pipelineDTO.getClassificationType()) || pipelineDTO.getClassificationType() != 2) {
            return null;
        }
        return pipelineDTO.getId();
    }

    @Override
    public Integer getRemoveDataId(Object ... dataParam) {
        Object[] args = (Object[])dataParam[0];
        Integer dataId = Integer.valueOf(String.valueOf(args[1]));
        return dataId;
    }

    @Override
    public void compensateAssetsToEsErrorDataSave(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        ProcessDefinitionVO processDefinitionVO = this.queryProcessDefinitionById(tDsAssetsOperationRecord.getDataId());
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(processDefinitionVO.getId());
        dataAssetsVO.setName(processDefinitionVO.getName());
        dataAssetsVO.setCreateTime(tDsAssetsOperationRecord.getOperationTime());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_PIPELINE.getCode());
        dataAssetsVO.setProject(processDefinitionVO.getProjectName());
        dataAssetsVO.setTenantId(processDefinitionVO.getTenantId());
        String key = String.valueOf(processDefinitionVO.getId()).concat("_").concat(DataCatalogClassificationType.DATA_PIPELINE.name());
        this.dataSaveEs(key, dataAssetsVO);
    }

    @Override
    public void compensateAssetsToEsErrorDataUpdate(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        this.compensateAssetsToEsErrorDataDelete(tDsAssetsOperationRecord);
        this.compensateAssetsToEsErrorDataSave(tDsAssetsOperationRecord);
    }

    @Override
    public void compensateAssetsToEsErrorDataDelete(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        String id = String.valueOf(tDsAssetsOperationRecord.getDataId()).concat("_").concat(DataCatalogClassificationType.DATA_PIPELINE.name());
        this.dataRemoveEs(id);
    }

    @Autowired
    public DataPipelineProcessor(DsService dsService) {
        this.dsService = dsService;
    }
}

