/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.es;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.es.DocDelete;
import com.digiwin.commons.entity.model.es.DocInsert;
import com.digiwin.commons.entity.model.es.DocPainlessUpdate;
import com.digiwin.commons.entity.model.es.DocQuery;
import com.digiwin.commons.entity.model.es.DocUpdate;
import com.digiwin.commons.entity.model.es.Index;
import com.digiwin.commons.entity.vo.IndicesDetailsInfo;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.processor.es.EsBaseProcessor;
import com.digiwin.commons.utils.CollectionsUtils;
import com.digiwin.commons.utils.ElasticRestClientUtils;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="esRestClientProcessor")
@ConditionalOnProperty(name={"default.elastic.enable"}, havingValue="true")
public class EsRestClientProcessor
extends EsBaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(EsRestClientProcessor.class);
    @Autowired
    private ElasticRestClientUtils elasticRestClientUtils;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Value(value="${default.elastic.insert.processor-close-time:20}")
    private Long processorCloseTime;

    @Override
    public Boolean indexCreate(Index index) {
        Boolean flag = true;
        try {
            if (this.checkIndexExists(index).booleanValue()) {
                log.info(" index already exists ! ");
                throw new BusinessException(Status.INDEX_ALREADY_EXISTS);
            }
            CreateIndexRequest request = new CreateIndexRequest(index.getName());
            Optional.ofNullable(index.getIndexParam()).filter(StringUtils::isNotBlank).ifPresent(i -> request.source(i, XContentType.JSON));
            CreateIndexResponse createIndexResponse = this.restHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
            log.info(" create index result : {} ", (Object)createIndexResponse.isAcknowledged());
        }
        catch (IOException e) {
            log.error(" create index error , e : {} ", (Throwable)e);
            throw new BusinessException("create index error !");
        }
        return flag;
    }

    @Override
    public Boolean checkIndexExists(Index index) throws IOException {
        Boolean exists = false;
        GetIndexRequest request = new GetIndexRequest(new String[]{index.getName()});
        request.local(false);
        request.humanReadable(true);
        request.includeDefaults(false);
        exists = this.restHighLevelClient.indices().exists(request, RequestOptions.DEFAULT);
        return exists;
    }

    @Override
    public Object docBatchInsert(DocInsert docs) {
        ArrayList<String> errorDataList = new ArrayList<String>();
        BulkRequest request = new BulkRequest(docs.getIndex());
        try {
            log.info(" start to execute batch insert , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataMap().size());
            Map<String, String> data = docs.getDataMap();
            if (CollectionsUtils.notEmpty(data).booleanValue()) {
                data.entrySet().forEach(i -> {
                    log.info("bulkRequest items:{},{}", (Object)docs.getIndex(), i.getKey());
                    IndexRequest indexRequest = new IndexRequest(docs.getIndex()).id((String)i.getKey());
                    if (StringUtils.isNotBlank(docs.getAttachment())) {
                        indexRequest.setPipeline(docs.getAttachment());
                    }
                    if (StringUtils.isNotBlank(docs.getRouting())) {
                        indexRequest.routing(docs.getRouting());
                    }
                    indexRequest.source((String)i.getValue(), XContentType.JSON);
                    request.add(indexRequest);
                });
            }
            request.timeout(TimeValue.timeValueSeconds((long)this.processorCloseTime));
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            bulkResponse.forEach(item -> {
                log.info("bulkRequest result:{},{}", (Object)item.getId(), (Object)item.status());
                BulkItemResponse.Failure failure = item.getFailure();
                if (failure != null && RestStatus.CONFLICT != failure.getStatus()) {
                    log.warn("bulkRequest fail:{},{}", (Object)item.getId(), (Object)item.status());
                    data.get(failure.getId());
                    errorDataList.add(JSONUtils.toJson(item));
                }
            });
            log.info(" execute batch insert success , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataMap().size());
        }
        catch (Exception e) {
            log.error(" bulkRequest error: {} ", (Throwable)e);
            errorDataList.add(JSONUtils.toJson(docs));
        }
        return errorDataList;
    }

    @Override
    public Boolean docBatchDeleteById(DocDelete docs) {
        Boolean flag = true;
        log.info(" start to execute batch delete , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataList().size());
        AtomicReference<BulkProcessor> processor = new AtomicReference<BulkProcessor>(this.elasticRestClientUtils.getBulkProcessor(this.restHighLevelClient));
        try {
            Optional.ofNullable(docs.getDataList()).filter(CollectionsUtils::notEmpty).ifPresent(i -> i.forEach(k -> {
                DeleteRequest deleteRequest = new DeleteRequest(docs.getIndex(), k);
                if (StringUtils.isNotBlank(docs.getRouting())) {
                    deleteRequest.routing(docs.getRouting());
                }
                ((BulkProcessor)processor.get()).add(deleteRequest);
            }));
            processor.get().awaitClose(this.processorCloseTime.longValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            processor.get().close();
            log.error(" delete doc error,e :{} ", (Throwable)e);
            throw new BusinessException("delete doc error \uff01");
        }
        log.info(" execute batch delete success , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataList().size());
        return flag;
    }

    @Override
    public Object docDeleteByQuery(DocQuery docQuery) {
        try {
            RestClient restClient = this.restHighLevelClient.getLowLevelClient();
            NStringEntity entity = new NStringEntity(docQuery.getParam(), ContentType.APPLICATION_JSON);
            Request request = new Request("POST", String.format("/%s/%s", docQuery.getIndex(), "_delete_by_query"));
            if (CollectionsUtils.notEmpty((Map)docQuery.getUrlParamJson()).booleanValue()) {
                Map<String, String> urlParamMap = JSONUtils.toMap(JSONUtils.toJson(docQuery.getUrlParamJson()));
                request.addParameters(urlParamMap);
            }
            request.setEntity((HttpEntity)entity);
            Response response = restClient.performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject result = JSONUtils.parseObject(responseBody);
            return result.getString("task");
        }
        catch (IOException e) {
            log.error(" doc delete by query error , e:{}", (Throwable)e);
            throw new BusinessException("doc delete by query error");
        }
    }

    @Override
    public Object query(DocQuery docQuery) {
        try {
            String queryParamJson = docQuery.getParam() == null ? JSONUtils.toJsonString(docQuery.getJsonParam()) : docQuery.getParam();
            RestClient restClient = this.restHighLevelClient.getLowLevelClient();
            NStringEntity entity = new NStringEntity(queryParamJson, ContentType.APPLICATION_JSON);
            Request request = new Request("POST", String.format("/%s/%s", docQuery.getIndex(), "_search"));
            if (CollectionsUtils.notEmpty((Map)docQuery.getUrlParamJson()).booleanValue()) {
                Map<String, String> urlParamMap = JSONUtils.toMap(JSONUtils.toJson(docQuery.getUrlParamJson()));
                request.addParameters(urlParamMap);
            }
            request.setEntity((HttpEntity)entity);
            Response response = restClient.performRequest(request);
            return JSONUtils.parseObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            log.error(" query es error , e: {} ", (Throwable)e);
            throw new BusinessException("query es error !");
        }
    }

    @Override
    public Boolean docUpdateById(DocUpdate docUpdate) {
        Boolean flag = true;
        log.info(" start to execute batch update , index : {} , size : {} ", (Object)docUpdate.getIndex(), (Object)docUpdate.getIdList().size());
        AtomicReference<BulkProcessor> processor = new AtomicReference<BulkProcessor>(this.elasticRestClientUtils.getBulkProcessor(this.restHighLevelClient));
        HashMap dataMapObject = new HashMap();
        Optional.ofNullable(docUpdate.getDataMapObject()).ifPresent(o -> dataMapObject.putAll(docUpdate.getDataMapObject()));
        Optional.ofNullable(docUpdate.getDataMap()).ifPresent(o -> dataMapObject.putAll(docUpdate.getDataMap()));
        try {
            Optional.ofNullable(docUpdate.getIdList()).filter(CollectionsUtils::notEmpty).ifPresent(i -> i.forEach(k -> {
                UpdateRequest updateRequest = new UpdateRequest(docUpdate.getIndex(), k).doc(JSONUtils.toJson(dataMapObject), XContentType.JSON);
                if (StringUtils.isNotBlank(docUpdate.getRouting())) {
                    updateRequest.routing(docUpdate.getRouting());
                }
                ((BulkProcessor)processor.get()).add((DocWriteRequest)updateRequest);
            }));
            processor.get().awaitClose(this.processorCloseTime.longValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            processor.get().close();
            log.error(" update doc error,e :{} ", (Throwable)e);
            throw new BusinessException(" update doc error!");
        }
        log.info(" execute batch update success , index : {} , size : {} ", (Object)docUpdate.getIndex(), (Object)docUpdate.getIdList().size());
        return flag;
    }

    @Override
    public Boolean docAllUpdate(DocPainlessUpdate docPainlessUpdate) {
        Boolean flag = true;
        try {
            UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{docPainlessUpdate.getIndex()});
            request.setConflicts("proceed");
            request.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
            Map<String, Object> parameters = docPainlessUpdate.getDataMapObject();
            Script inline = new Script(ScriptType.INLINE, "painless", docPainlessUpdate.getPainless(), parameters);
            request.setScript(inline);
            BulkByScrollResponse bulkResponse = this.restHighLevelClient.updateByQuery(request, RequestOptions.DEFAULT);
            Long updatedDocuments = bulkResponse.getUpdated();
            log.info("update all documents rows:{}", (Object)updatedDocuments);
        }
        catch (IOException e) {
            log.error(" update all doc error,e :{} ", (Throwable)e);
            throw new BusinessException(" update all doc error!");
        }
        return flag;
    }

    @Override
    public Object indicesGet(Index index) {
        if (StringUtils.isBlank(index.getName())) {
            throw new BusinessException(" index name is null!");
        }
        try {
            IndicesDetailsInfo indicesDetailsInfo = new IndicesDetailsInfo();
            GetIndexRequest request = new GetIndexRequest(new String[]{index.getName()});
            GetIndexResponse getIndexResponse = this.restHighLevelClient.indices().get(request, RequestOptions.DEFAULT);
            BeanUtil.copyProperties((Object)getIndexResponse, (Object)indicesDetailsInfo, (String[])new String[0]);
            return indicesDetailsInfo;
        }
        catch (IOException e) {
            log.error(" query es structure details info error , e: {} ", (Throwable)e);
            throw new BusinessException("query es structure details info error !");
        }
    }
}

