/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.model.TreeNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(TreeNodeUtils.class);

    public static TreeNode buildTree(Integer parentId, Map<Integer, TreeNode> nodeMap) {
        TreeNode parent = nodeMap.get(parentId);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        for (TreeNode node : nodeMap.values()) {
            if (parentId == null && node.getParentId() == null || node.getParentId() == null || !node.getParentId().equals(parentId)) continue;
            children.add(node);
        }
        ArrayList<TreeNode> subTreeNodeList = new ArrayList<TreeNode>();
        for (TreeNode child : children) {
            TreeNode subTree = TreeNodeUtils.buildTree(child.getId(), nodeMap);
            subTreeNodeList.add(subTree);
        }
        subTreeNodeList.sort(Comparator.comparingInt(TreeNode::getSort));
        parent.setChildren(subTreeNodeList);
        return parent;
    }
}

