/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.enums.DataCatalogClassificationType;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.es.DocDelete;
import com.digiwin.commons.entity.model.es.DocInsert;
import com.digiwin.commons.entity.model.quality.DataQuality;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import feign.Request;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DataQualityProcessor
extends DataAssetsBaseProcessor<DataQuality> {
    private static final Logger log = LoggerFactory.getLogger(DataQualityProcessor.class);
    @Autowired
    private DaasService daasService;
    @Autowired
    private DsService dsService;

    @Override
    public void save(DataQuality dataQuality) {
        DocInsert docInsert = new DocInsert();
        docInsert.setIndex("dmp_full_data_idx");
        HashMap<String, JSONObject> dataJsonMap = new HashMap<String, JSONObject>();
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(dataQuality.getId());
        dataAssetsVO.setName(dataQuality.getName());
        dataAssetsVO.setCreateTime(new Date());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_QUALITY.getCode());
        dataAssetsVO.setProject(dataQuality.getProjectName());
        dataAssetsVO.setTenantId(dataQuality.getTenantId());
        String key = String.valueOf(dataQuality.getId()).concat("_").concat(DataCatalogClassificationType.DATA_QUALITY.name());
        dataJsonMap.put(key, JSONUtils.parseObject(JSONUtils.toJson(dataAssetsVO)));
        docInsert.setDataJsonMap(dataJsonMap);
        this.daasService.saveEsInfo(docInsert, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void bindCatalog(DataQuality dataQuality) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(dataQuality.getId()).catalogIds(dataQuality.getCatalogIds()).classificationType(DataCatalogClassificationType.DATA_QUALITY.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void unbindCatalog(Object[] args) {
        JSONObject jsonObject = JSONUtils.parseObject(JSONUtils.toJson(args[0]));
        Integer id = Integer.valueOf(jsonObject.getString("id"));
        this.unbindCatalogById(id);
    }

    private void unbindCatalogById(Integer id) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(id).classificationType(DataCatalogClassificationType.DATA_QUALITY.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void update(DataQuality dataQuality) {
        Object[] obj = new Object[]{dataQuality};
        this.remove(obj);
        this.save(dataQuality);
    }

    @Override
    public void remove(Object obj) {
        Object[] args = (Object[])obj;
        DocDelete docDelete = new DocDelete();
        docDelete.setIndex("dmp_full_data_idx");
        ArrayList<String> dataList = new ArrayList<String>();
        JSONObject jsonObject = JSONUtils.parseObject(JSONUtils.toJson(args[0]));
        String id = jsonObject.getString("id").concat("_").concat(DataCatalogClassificationType.DATA_QUALITY.name());
        dataList.add(id);
        docDelete.setDataList(dataList);
        this.daasService.deleteEsInfo(docDelete, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
        if (!ObjectUtils.isEmpty((Object)jsonObject.getString("id"))) {
            this.unbindCatalogById(Integer.valueOf(jsonObject.getString("id")));
        }
    }

    @Override
    public void copy(Object obj) {
        Object[] args = (Object[])obj;
    }

    @Override
    public DataQuality getToEsArgs(Object ... dataParam) {
        UserInfo userInfo = UserInfoContext.getContext();
        Object[] args = (Object[])dataParam[0];
        DataQuality dataQuality = JSONUtils.parseObject(JSONUtils.toJson(args[0]), DataQuality.class);
        if (dataQuality.getId() == null || dataQuality.getId() == 0) {
            Result result = JSONUtils.parseObject(JSONUtils.toJson(dataParam[1]), Result.class);
            dataQuality.setId(Integer.valueOf(String.valueOf(result.getData())));
        }
        dataQuality.setTenantId(userInfo.getTenantId());
        return dataQuality;
    }
}

