/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.dto.pipeline.PipelineDTO;
import com.digiwin.commons.entity.enums.DataCatalogClassificationType;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.es.DocDelete;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import feign.Request;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DataPipelineProcessor
extends DataAssetsBaseProcessor<PipelineDTO> {
    private static final Logger log = LoggerFactory.getLogger(DataPipelineProcessor.class);
    @Autowired
    private DaasService daasService;
    @Autowired
    private DsService dsService;

    @Override
    public Integer save(PipelineDTO pipelineDTO) {
        Integer dataId = pipelineDTO.getId();
        if (ObjectUtil.isNull((Object)pipelineDTO.getClassificationType()) || pipelineDTO.getClassificationType() != 2) {
            return null;
        }
        HashMap<String, JSONObject> dataJsonMap = new HashMap<String, JSONObject>();
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(pipelineDTO.getId());
        dataAssetsVO.setName(pipelineDTO.getName());
        dataAssetsVO.setCreateTime(new Date());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_PIPELINE.getCode());
        dataAssetsVO.setProject(pipelineDTO.getProjectName());
        dataAssetsVO.setTenantId(pipelineDTO.getTenantId());
        String key = String.valueOf(pipelineDTO.getId()).concat("_").concat(DataCatalogClassificationType.DATA_PIPELINE.name());
        dataJsonMap.put(key, JSONUtils.parseObject(JSONUtils.toJson(dataAssetsVO)));
        this.dataSaveEs(dataJsonMap);
        return dataId;
    }

    @Override
    public void bindCatalog(PipelineDTO pipelineDTO) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(pipelineDTO.getId()).catalogIds(pipelineDTO.getCatalogIds()).classificationType(DataCatalogClassificationType.DATA_PIPELINE.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void unbindCatalog(Object[] args) {
        Integer id = Integer.valueOf(String.valueOf(args[1]));
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(id).classificationType(DataCatalogClassificationType.DATA_PIPELINE.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    private void unbindCatalogById(Integer id) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(id).classificationType(DataCatalogClassificationType.DATA_PIPELINE.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public Integer update(PipelineDTO pipelineDTO) {
        Object[] obj = new Object[3];
        obj[2] = pipelineDTO.getId();
        this.remove(obj);
        return this.save(pipelineDTO);
    }

    @Override
    public Integer remove(Object obj) {
        Integer dataId = null;
        Object[] args = (Object[])obj;
        DocDelete docDelete = new DocDelete();
        docDelete.setIndex("dmp_full_data_idx");
        ArrayList<String> dataList = new ArrayList<String>();
        String id = String.valueOf(args[1]).concat("_").concat(DataCatalogClassificationType.DATA_PIPELINE.name());
        dataId = Integer.valueOf(String.valueOf(args[1]));
        dataList.add(id);
        docDelete.setDataList(dataList);
        this.daasService.deleteEsInfo(docDelete, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
        if (!ObjectUtils.isEmpty((Object)args[1])) {
            this.unbindCatalogById(Integer.valueOf(String.valueOf(args[1])));
        }
        return dataId;
    }

    @Override
    public PipelineDTO getToEsArgs(Object ... dataParam) {
        UserInfo userInfo = UserInfoContext.getContext();
        Object[] args = (Object[])dataParam[0];
        PipelineDTO pipelineDTO = JSONUtils.parseObject(JSONUtils.toJson(args[1]), PipelineDTO.class);
        if (pipelineDTO.getId() == null || pipelineDTO.getId() == 0) {
            Result result = JSONUtils.parseObject(JSONUtils.toJson(dataParam[1]), Result.class);
            pipelineDTO.setId(Integer.valueOf(String.valueOf(result.getData())));
        }
        pipelineDTO.setTenantId(userInfo.getTenantId());
        return pipelineDTO;
    }
}

