/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import java.math.BigDecimal;

public class CommonUtils {
    public static String adaptionStorageUnit(BigDecimal size) {
        BigDecimal bigDecimal = new BigDecimal(0x40000000);
        if (size.compareTo(new BigDecimal(1024)) == -1) {
            return "B";
        }
        if (size.compareTo(new BigDecimal(0x100000)) == -1) {
            return "KB";
        }
        if (size.compareTo(new BigDecimal(0x40000000)) == -1) {
            return "MB";
        }
        if (size.compareTo(bigDecimal.multiply(new BigDecimal(1024))) == -1) {
            return "GB";
        }
        return "TB";
    }

    public static BigDecimal adaptionStorageSize(String unit, BigDecimal size) {
        switch (unit) {
            case "B": {
                return size;
            }
            case "KB": {
                return size.divide(BigDecimal.valueOf(1024L), 2, 4);
            }
            case "MB": {
                return size.divide(BigDecimal.valueOf(0x100000L), 2, 4);
            }
            case "GB": {
                return size.divide(BigDecimal.valueOf(0x40000000L), 2, 4);
            }
        }
        BigDecimal bigDecimal = new BigDecimal(0x40000000);
        return size.divide(bigDecimal.multiply(new BigDecimal(1024)), 2, 4);
    }

    public static String adaptionStorageSizeUnit(BigDecimal size) {
        BigDecimal bigDecimal = new BigDecimal(0x40000000);
        if (size.compareTo(new BigDecimal(1024)) == -1) {
            return size + "B";
        }
        if (size.compareTo(new BigDecimal(0x100000)) == -1) {
            return size.divide(BigDecimal.valueOf(1024L), 2, 4) + "KB";
        }
        if (size.compareTo(new BigDecimal(0x40000000)) == -1) {
            return size.divide(BigDecimal.valueOf(0x100000L), 2, 4) + "MB";
        }
        if (size.compareTo(bigDecimal.multiply(new BigDecimal(1024))) == -1) {
            return size.divide(BigDecimal.valueOf(0x40000000L), 2, 4) + "GB";
        }
        return size.divide(bigDecimal.multiply(new BigDecimal(1024)), 2, 4) + "TB";
    }
}

