/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.enums.ResUploadType;
import com.digiwin.commons.utils.PropertyUtils;
import com.digiwin.commons.utils.StringUtils;
import java.math.BigDecimal;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static String adaptionStorageUnit(BigDecimal size) {
        BigDecimal bigDecimal = new BigDecimal(0x40000000);
        if (size.compareTo(new BigDecimal(1024)) == -1) {
            return "B";
        }
        if (size.compareTo(new BigDecimal(0x100000)) == -1) {
            return "KB";
        }
        if (size.compareTo(new BigDecimal(0x40000000)) == -1) {
            return "MB";
        }
        if (size.compareTo(bigDecimal.multiply(new BigDecimal(1024))) == -1) {
            return "GB";
        }
        return "TB";
    }

    public static BigDecimal adaptionStorageSize(String unit, BigDecimal size) {
        switch (unit) {
            case "B": {
                return size;
            }
            case "KB": {
                return size.divide(BigDecimal.valueOf(1024L), 2, 4);
            }
            case "MB": {
                return size.divide(BigDecimal.valueOf(0x100000L), 2, 4);
            }
            case "GB": {
                return size.divide(BigDecimal.valueOf(0x40000000L), 2, 4);
            }
        }
        BigDecimal bigDecimal = new BigDecimal(0x40000000);
        return size.divide(bigDecimal.multiply(new BigDecimal(1024)), 2, 4);
    }

    public static String adaptionStorageSizeUnit(BigDecimal size) {
        BigDecimal bigDecimal = new BigDecimal(0x40000000);
        if (size.compareTo(new BigDecimal(1024)) == -1) {
            return size + "B";
        }
        if (size.compareTo(new BigDecimal(0x100000)) == -1) {
            return size.divide(BigDecimal.valueOf(1024L), 2, 4) + "KB";
        }
        if (size.compareTo(new BigDecimal(0x40000000)) == -1) {
            return size.divide(BigDecimal.valueOf(0x100000L), 2, 4) + "MB";
        }
        if (size.compareTo(bigDecimal.multiply(new BigDecimal(1024))) == -1) {
            return size.divide(BigDecimal.valueOf(0x40000000L), 2, 4) + "GB";
        }
        return size.divide(bigDecimal.multiply(new BigDecimal(1024)), 2, 4) + "TB";
    }

    private CommonUtils() {
        throw new UnsupportedOperationException("Construct CommonUtils");
    }

    public static String getSystemEnvPath() {
        String envPath = PropertyUtils.getString("dolphinscheduler.env.path");
        if (StringUtils.isEmpty(envPath)) {
            URL envDefaultPath = CommonUtils.class.getClassLoader().getResource("env/dolphinscheduler_env.sh");
            if (envDefaultPath != null) {
                envPath = envDefaultPath.getPath();
                logger.debug("env path :{}", (Object)envPath);
            } else {
                envPath = "/etc/profile";
            }
        }
        return envPath;
    }

    public static boolean isDevelopMode() {
        return PropertyUtils.getBoolean("development.state", true);
    }

    public static boolean getKerberosStartupState() {
        String resUploadStartupType = PropertyUtils.getString("resource.storage.type");
        ResUploadType resUploadType = ResUploadType.valueOf(resUploadStartupType);
        Boolean kerberosStartupState = PropertyUtils.getBoolean("hadoop.security.authentication.startup.state", false);
        return resUploadType == ResUploadType.HDFS && kerberosStartupState != false;
    }

    public static void loadKerberosConf() throws Exception {
        if (CommonUtils.getKerberosStartupState()) {
            System.setProperty("java.security.krb5.conf", PropertyUtils.getString("java.security.krb5.conf.path"));
            Configuration configuration = new Configuration();
            configuration.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)PropertyUtils.getString("login.user.keytab.username"), (String)PropertyUtils.getString("login.user.keytab.path"));
        }
    }
}

