/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.enums.DataCatalogClassificationType;
import com.digiwin.commons.entity.model.ds.TDsAssetsOperationRecord;
import com.digiwin.commons.entity.vo.dap.TDapTableVO;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.feign.client.MetaService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import feign.Request;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"data.assets.enable"}, havingValue="true", matchIfMissing=true)
public class DataTableProcessor
extends DataAssetsBaseProcessor<TDapTableVO> {
    private static final Logger log = LoggerFactory.getLogger(DataTableProcessor.class);
    @Autowired
    private DsService dsService;
    @Autowired
    private MetaService metaService;

    @Override
    public void bindCatalog(TDapTableVO tDapTableVO) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(tDapTableVO.getId()).catalogIds(tDapTableVO.getCatalogIds()).classificationType(DataCatalogClassificationType.DATA_TABLE.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void unbindCatalog(Object[] args) {
        Integer id = Integer.valueOf(String.valueOf(args[0]));
        this.unbindCatalogById(id);
    }

    public void unbindCatalogById(Integer id) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(id).classificationType(DataCatalogClassificationType.DATA_TABLE.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public TDapTableVO getToEsArgs(Object ... dataParam) {
        Object[] args = (Object[])dataParam[0];
        TDapTableVO tDapTableVO = JSONUtils.parseObject(JSONUtils.toJson(args[0]), TDapTableVO.class);
        return tDapTableVO;
    }

    @Override
    public void compensateAssetsToEsErrorDataSave(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        this.metaService.metaTableInfoSaveOrUpdate(tDsAssetsOperationRecord.getTableGuid(), false, new Request.Options(5L, TimeUnit.SECONDS, 15L, TimeUnit.SECONDS, true));
    }

    @Override
    public void compensateAssetsToEsErrorDataUpdate(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        this.compensateAssetsToEsErrorDataDelete(tDsAssetsOperationRecord);
        this.compensateAssetsToEsErrorDataSave(tDsAssetsOperationRecord);
    }

    @Override
    public void compensateAssetsToEsErrorDataDelete(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        this.metaService.deleteByGuid(tDsAssetsOperationRecord.getTableGuid());
    }
}

