/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.digiwin.commons.annotation.EnumDict;

public enum ExecutionStatus {
    SUBMITTED_SUCCESS(0, "submit success"),
    RUNNING_EXECUTION(1, "running"),
    READY_PAUSE(2, "ready pause"),
    PAUSE(3, "pause"),
    READY_STOP(4, "ready stop"),
    STOP(5, "stop"),
    FAILURE(6, "failure"),
    SUCCESS(7, "success"),
    NEED_FAULT_TOLERANCE(8, "need fault tolerance"),
    KILL(9, "kill"),
    WAITTING_THREAD(10, "waiting thread"),
    WAITTING_DEPEND(11, "waiting depend node complete");

    @EnumValue
    @EnumDict(value=0)
    private final int code;
    @EnumDict(value=1)
    private final String descp;

    private ExecutionStatus(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public boolean typeIsSuccess() {
        return this == SUCCESS;
    }

    public boolean typeIsFailure() {
        return this == FAILURE || this == NEED_FAULT_TOLERANCE;
    }

    public boolean typeIsFinished() {
        return this.typeIsSuccess() || this.typeIsFailure() || this.typeIsCancel() || this.typeIsPause() || this.typeIsStop();
    }

    public boolean typeIsWaitingThread() {
        return this == WAITTING_THREAD;
    }

    public boolean typeIsPause() {
        return this == PAUSE;
    }

    public boolean typeIsStop() {
        return this == STOP;
    }

    public boolean typeIsStopOrReadyStop() {
        return this == STOP || this == READY_STOP;
    }

    public boolean typeIsRunning() {
        return this == RUNNING_EXECUTION || this == WAITTING_DEPEND;
    }

    public boolean typeIsCancel() {
        return this == KILL || this == STOP;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static ExecutionStatus of(int status) {
        for (ExecutionStatus es : ExecutionStatus.values()) {
            if (es.getCode() != status) continue;
            return es;
        }
        throw new IllegalArgumentException("invalid status : " + status);
    }
}

