/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.vo.lineage.DataLineage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.annotation.PostConstruct;
import jep.MainInterpreter;
import jep.SharedInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SqlLineageUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlLineageUtils.class);
    @Value(value="${sqlLineageScriptPath}")
    private String sqlLineageScriptPath;
    private static String staticSqlLineageScriptPath;
    @Value(value="${jepPath}")
    private String jepPath;

    @PostConstruct
    public void init() {
        MainInterpreter.setJepLibraryPath((String)this.jepPath);
        staticSqlLineageScriptPath = this.sqlLineageScriptPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<DataLineage> getDataLineage(String sql, String dialect) {
        try (SharedInterpreter interpreter = new SharedInterpreter();){
            interpreter.runScript(staticSqlLineageScriptPath);
            interpreter.set("sql", (Object)sql);
            interpreter.set("dialect", (Object)dialect);
            interpreter.eval("result = get_lineage(sql, dialect)");
            Object result = interpreter.getValue("result");
            ObjectMapper mapper = new ObjectMapper();
            Optional<Object> optional = Optional.of(mapper.readValue(mapper.writeValueAsString(result), DataLineage.class));
            return optional;
        }
        catch (Exception e) {
            log.error("sql\u89e3\u6790\u5931\u8d25,\u8bf7\u68c0\u67e5sql, sql :{}, type :{}", (Object)sql, (Object)dialect);
            return Optional.empty();
        }
    }
}

