/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.context;

import cn.hutool.core.lang.Pair;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.DsService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class AesSecretKeyContext {
    @Autowired
    private DsService dsService;
    private static final Map<Long, Pair<String, String>> SECRET_KEY_MAP = new HashMap<Long, Pair<String, String>>();

    @PostConstruct
    public void init() {
    }

    public static void refreshSecretKeyMap(Long tenantId, String secretKey, String aesKey) {
        Pair secretKeyPair = Pair.of((Object)secretKey, (Object)aesKey);
        SECRET_KEY_MAP.put(tenantId, (Pair<String, String>)secretKeyPair);
    }

    public static String getAesKey(Long tenantId, String secretKey) {
        Pair<String, String> secretKeyPair = SECRET_KEY_MAP.get(tenantId);
        if (ObjectUtils.isEmpty(secretKeyPair)) {
            throw new BusinessException(Status.AES_SECRET_KEY_BY_TENANT_IS_EMPTY_ERROR);
        }
        String key = (String)secretKeyPair.getKey();
        if (!ObjectUtils.nullSafeEquals((Object)key, (Object)secretKey)) {
            throw new BusinessException(Status.AES_SECRET_KEY_IS_INVALID_ERROR);
        }
        return (String)secretKeyPair.getValue();
    }

    public static String getAesKey(Long tenantId) {
        Pair<String, String> secretKeyPair = SECRET_KEY_MAP.get(tenantId);
        if (ObjectUtils.isEmpty(secretKeyPair)) {
            throw new BusinessException(Status.AES_SECRET_KEY_BY_TENANT_IS_EMPTY_ERROR);
        }
        return (String)secretKeyPair.getValue();
    }

    @Autowired
    public AesSecretKeyContext() {
    }
}

