/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DbType {
    MYSQL(0, "mysql", 1, "5.7.x\u30018.0\u30018.2"),
    POSTGRESQL(1, "postgresql", 1, "9.2.x"),
    HIVE(2, "hive", 4, "2.0\u30012.1.1\u30012.1.2"),
    SPARK(3, "spark", 4, "2.0\u30012.4.0"),
    CLICKHOUSE(4, "clickhouse", 4, "20.0\u300121.x\u300122.x\u300123.6.2"),
    ORACLE(5, "oracle", 1, "12c\u300119c"),
    SQLSERVER(6, "sqlserver", 1, "2012\u30012013\u30012014\u30012016\u30012017\u30012018\u30012019"),
    DB2(7, "db2", 1, "7.2.0\u30017.4.0"),
    IMPALA(8, "impala", 4, "3.x\u30013.2.0\u30013.4.0\u30012.12.0\u30012.7.0"),
    ES(9, "es", 3, "6.x\u30017.x"),
    STARROCKS(10, "starrocks", 4, "3.0\u30013.1\u30013.2\u30013.3"),
    GREENPLUM(11, "greenplum", 1, "5.x"),
    KAFKA(12, "kafka", 2, "2.1.0"),
    DM(13, "dm", 1, "8.x"),
    KINGBASEES(14, "kingbasees", 1, "V8R6\u3001V8R3"),
    STANDARD(-1, "standard", 0, "");

    private static final Logger log;
    @EnumValue
    private final int code;
    private final String desc;
    private final int type;
    private final String version;

    private DbType(int code, String desc, int type, String version) {
        this.code = code;
        this.desc = desc;
        this.type = type;
        this.version = version;
    }

    public static DbType of(int type) {
        for (DbType ty : DbType.values()) {
            if (ty.getCode() != type) continue;
            return ty;
        }
        return null;
    }

    public static DbType of(String desc) {
        for (DbType ty : DbType.values()) {
            if (!StringUtils.equals((String)ty.getDesc(), (String)desc)) continue;
            return ty;
        }
        return null;
    }

    public static DbType valueOfUpper(String desc) {
        if (StringUtils.isBlank((String)desc)) {
            log.error("desc is empty");
            return null;
        }
        for (DbType ty : DbType.values()) {
            if (!StringUtils.equals((String)ty.getDesc().toUpperCase(), (String)desc)) continue;
            return ty;
        }
        return null;
    }

    public static Enum<DbType> indexOf(Integer index) {
        return Arrays.stream(DbType.values()).filter(i -> i.ordinal() == index.intValue()).findAny().orElse(null);
    }

    public int getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getVersion() {
        return this.version;
    }

    static {
        log = LoggerFactory.getLogger(DbType.class);
    }
}

