/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.security;

import com.digiwin.commons.entity.enums.HideTemplateType;
import com.digiwin.commons.entity.model.security.HideRuleConfig;
import com.digiwin.commons.entity.model.security.TDsDataSecurityRuleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HideRule {
    public static final Logger logger = LoggerFactory.getLogger(HideRule.class);

    public static String hideFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData) {
        HideRuleConfig config = (HideRuleConfig)ruleConfig;
        HideTemplateType hideTemplateType = config.getHideTemplateType();
        switch (hideTemplateType) {
            case RETAIN_THE_FIRST_N_AND_THEN_M: {
                return HideRule.retainTheFirstNAndThenM(config, originalData);
            }
            case RETAIN_THE_FIRST_X_AND_THEN_Y: {
                return HideRule.retainTheFirstXAndThenY(config, originalData);
            }
            case COVER_THE_FIRST_N_AND_THEN_M: {
                return HideRule.coverTheFirstNAndThenM(config, originalData);
            }
            case COVER_THE_FIRST_X_AND_THEN_Y: {
                return HideRule.coverTheFirstXAndThenY(config, originalData);
            }
        }
        return originalData;
    }

    private static String retainTheFirstNAndThenM(HideRuleConfig config, String originalData) {
        int startIndex = config.getStartIndex();
        int endIndex = originalData.length() - config.getEndIndex();
        StringBuilder stringBuilder = new StringBuilder(originalData);
        HideRule.stringBuilderReplace(stringBuilder, startIndex, endIndex, config.getReplaceStr());
        return stringBuilder.toString();
    }

    private static String retainTheFirstXAndThenY(HideRuleConfig config, String originalData) {
        int endIndex;
        int startIndex = config.getStartIndex() - 1;
        StringBuilder stringBuilder = new StringBuilder(originalData);
        if (0 < startIndex) {
            HideRule.stringBuilderReplace(stringBuilder, 0, startIndex, config.getReplaceStr());
        }
        if ((endIndex = config.getEndIndex().intValue()) < 0 || endIndex > originalData.length()) {
            return stringBuilder.toString();
        }
        HideRule.stringBuilderReplace(stringBuilder, endIndex, originalData.length(), config.getReplaceStr());
        return stringBuilder.toString();
    }

    private static String coverTheFirstNAndThenM(HideRuleConfig config, String originalData) {
        int endIndex;
        StringBuilder stringBuilder = new StringBuilder(originalData);
        if (config.getStartIndex() >= originalData.length() || config.getEndIndex() >= originalData.length()) {
            HideRule.stringBuilderReplace(stringBuilder, 0, originalData.length(), config.getReplaceStr());
            return stringBuilder.toString();
        }
        int startIndex = config.getStartIndex();
        if (0 < startIndex) {
            HideRule.stringBuilderReplace(stringBuilder, 0, startIndex, config.getReplaceStr());
        }
        if ((endIndex = originalData.length() - config.getEndIndex()) < 0 || endIndex > originalData.length()) {
            return stringBuilder.toString();
        }
        HideRule.stringBuilderReplace(stringBuilder, endIndex, originalData.length(), config.getReplaceStr());
        return stringBuilder.toString();
    }

    private static String coverTheFirstXAndThenY(HideRuleConfig config, String originalData) {
        int startIndex = config.getStartIndex();
        int endIndex = config.getEndIndex() + 1;
        StringBuilder stringBuilder = new StringBuilder(originalData);
        HideRule.stringBuilderReplace(stringBuilder, startIndex, endIndex, config.getReplaceStr());
        return stringBuilder.toString();
    }

    private static StringBuilder stringBuilderReplace(StringBuilder stringBuilder, int start, int end, String str) {
        try {
            for (int i = start; i < end; ++i) {
                stringBuilder.setCharAt(i, str.charAt(0));
            }
        }
        catch (Exception e) {
            return stringBuilder;
        }
        return stringBuilder;
    }
}

