/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import org.springframework.util.ObjectUtils;

public enum TableOperationType {
    ALTER_TABLE(1, "alter table"),
    DROP_TABLE(2, "drop table"),
    ADD_PARTITION(3, "add partition"),
    DROP_PARTITION(4, "drop partition");

    @EnumValue
    private final int code;
    private final String desc;

    private TableOperationType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (TableOperationType ty : TableOperationType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static Integer of(int type) {
        for (TableOperationType ty : TableOperationType.values()) {
            if (ty.getCode() != type) continue;
            return ty.getCode();
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

