/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.context;

import cn.hutool.core.lang.Pair;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.AesSecretKey;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.DsService;
import feign.Request;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class AesSecretKeyContext {
    private static final Logger log = LoggerFactory.getLogger(AesSecretKeyContext.class);
    @Autowired
    private DsService dsService;
    private static final Map<Long, Pair<String, String>> SECRET_KEY_MAP = new HashMap<Long, Pair<String, String>>();

    @PostConstruct
    public void refresh() {
        log.info("init Secret Key ");
        Result<List<AesSecretKey>> listResult = this.dsService.selectAesSecretKeyInvalid(new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
        Optional.ofNullable(listResult).ifPresent(result -> {
            if (!result.getCode().equals(Status.SUCCESS.getCode())) {
                log.error("query ds aes secret key info error\uff01errorInfo:{}", (Object)result.getMsg());
                throw new BusinessException(Status.QUERY_AES_SECRET_KEY_IS_EMPTY_ERROR);
            }
            log.info("refresh Secret Key ");
            AesSecretKeyContext.refreshSecretKeyMap((List)listResult.getData());
        });
        log.info("init Secret Key end");
    }

    public static void refreshSecretKeyMap(List<AesSecretKey> aesSecretKeyList) {
        aesSecretKeyList.forEach(aesSecretKey -> {
            Pair secretKeyPair = Pair.of((Object)aesSecretKey.getSecretKey(), (Object)aesSecretKey.getAesKey());
            SECRET_KEY_MAP.put(aesSecretKey.getTenantId(), (Pair<String, String>)secretKeyPair);
        });
    }

    public static String getAesKey(Long tenantId, String secretKey) {
        Pair<String, String> secretKeyPair = SECRET_KEY_MAP.get(tenantId);
        if (ObjectUtils.isEmpty(secretKeyPair)) {
            throw new BusinessException(Status.AES_SECRET_KEY_BY_TENANT_IS_EMPTY_ERROR);
        }
        String key = (String)secretKeyPair.getKey();
        if (!ObjectUtils.nullSafeEquals((Object)key, (Object)secretKey)) {
            throw new BusinessException(Status.AES_SECRET_KEY_IS_INVALID_ERROR);
        }
        return (String)secretKeyPair.getValue();
    }

    public static String getAesKey(Long tenantId) {
        Pair<String, String> secretKeyPair = SECRET_KEY_MAP.get(tenantId);
        if (ObjectUtils.isEmpty(secretKeyPair)) {
            throw new BusinessException(Status.AES_SECRET_KEY_BY_TENANT_IS_EMPTY_ERROR);
        }
        return (String)secretKeyPair.getValue();
    }

    @Autowired
    public AesSecretKeyContext() {
    }
}

