/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.security;

import cn.hutool.core.lang.Pair;
import com.digiwin.commons.context.AesSecretKeyContext;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.enums.EncryptTemplateType;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.security.EncryptConfig;
import com.digiwin.commons.entity.model.security.TDsDataSecurityRuleConfig;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.factory.BeanFactoryContext;
import com.digiwin.commons.utils.AesUtils;
import com.digiwin.commons.utils.Sm3Utils;
import com.digiwin.commons.utils.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.ObjectUtils;

public class EncryptRule {
    public static final Logger logger = LoggerFactory.getLogger(EncryptRule.class);
    private static BeanFactory beanFactory;

    public static String decryptFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData) {
        UserInfo userInfo = UserInfoContext.getContext();
        String aesKey = EncryptRule.getAesKey(userInfo.getTenantId(), ruleConfig.getAesSecretKey());
        if (StringUtils.isBlank(aesKey)) {
            throw new BusinessException(Status.AES_SECRET_KEY_IS_EMPTY_ERROR);
        }
        return AesUtils.decrypt(originalData, aesKey);
    }

    public static String encryptFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData) {
        EncryptConfig config = (EncryptConfig)ruleConfig;
        EncryptTemplateType encryptTemplateType = config.getEncryptTemplateType();
        switch (encryptTemplateType) {
            case MD5_RULE: {
                return EncryptRule.md5Hex(originalData + config.getSalt());
            }
            case SHA256_RULE: {
                return EncryptRule.sha256Hex(originalData + config.getSalt());
            }
            case SM3_RULE: {
                return Sm3Utils.sm3(originalData + config.getSalt());
            }
            case AES_RULE: {
                UserInfo userInfo = UserInfoContext.getContext();
                String aesKey = EncryptRule.getAesKey(userInfo.getTenantId());
                if (StringUtils.isBlank(aesKey)) {
                    throw new BusinessException(Status.AES_SECRET_KEY_IS_EMPTY_ERROR);
                }
                return AesUtils.encrypt(originalData, aesKey);
            }
        }
        return originalData;
    }

    public static String md5Hex(String originalData) {
        return DigestUtils.md5Hex((String)originalData);
    }

    public static String sha256Hex(String originalData) {
        return DigestUtils.sha256Hex((String)originalData);
    }

    public static String getAesKey(Long tenantId, String secretKey) {
        Pair<String, String> secretKeyPair = EncryptRule.getAesKeyPair(tenantId);
        String key = (String)secretKeyPair.getKey();
        if (!ObjectUtils.nullSafeEquals((Object)key, (Object)secretKey)) {
            throw new BusinessException(Status.AES_SECRET_KEY_IS_INVALID_ERROR);
        }
        return (String)secretKeyPair.getValue();
    }

    public static String getAesKey(Long tenantId) {
        return (String)EncryptRule.getAesKeyPair(tenantId).getValue();
    }

    private static Pair<String, String> getAesKeyPair(Long tenantId) {
        Pair<String, String> secretKeyPair = AesSecretKeyContext.getAesKeyPair(tenantId);
        if (!ObjectUtils.isEmpty(secretKeyPair)) {
            return secretKeyPair;
        }
        AesSecretKeyContext aesSecretKeyBean = BeanFactoryContext.findBeanByClass(AesSecretKeyContext.class);
        aesSecretKeyBean.refresh();
        secretKeyPair = AesSecretKeyContext.getAesKeyPair(tenantId);
        if (ObjectUtils.isEmpty(secretKeyPair)) {
            throw new BusinessException(Status.AES_SECRET_KEY_BY_TENANT_IS_EMPTY_ERROR);
        }
        return secretKeyPair;
    }
}

