/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.exceptions.BusinessException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AesUtils {
    public static SecretKey generateAESKeySecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public static String generateAESKey() {
        SecretKey SecretKey2 = AesUtils.generateAESKeySecretKey();
        return Base64.getEncoder().encodeToString(SecretKey2.getEncoded());
    }

    public static String encrypt(String plainText, String aesSecretKey) {
        try {
            return AesUtils.encrypt(plainText, new SecretKeySpec(aesSecretKey.getBytes(), "AES"));
        }
        catch (Exception e) {
            return plainText;
        }
    }

    public static String decrypt(String plainText, String aesSecretKey) {
        try {
            return AesUtils.decrypt(plainText, new SecretKeySpec(aesSecretKey.getBytes(), "AES"));
        }
        catch (Exception e) {
            return plainText;
        }
    }

    public static String encrypt(String plainText, SecretKey secretKey) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKey);
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes());
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String decrypt(String encryptedText, SecretKey secretKey) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKey);
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedText);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return new String(decryptedBytes);
    }
}

