/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.security;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.entity.enums.SubstringTemplateType;
import com.digiwin.commons.entity.model.security.SubstringConfig;
import com.digiwin.commons.entity.model.security.TDsDataSecurityRuleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstringRule {
    public static final Logger logger = LoggerFactory.getLogger(SubstringRule.class);

    public static String substringFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData) {
        try {
            SubstringConfig config = (SubstringConfig)ruleConfig;
            SubstringTemplateType substringTemplateType = config.getSubstringTemplateType();
            switch (substringTemplateType) {
                case HOLD_RULE: {
                    return SubstringRule.holdRule(config, originalData);
                }
                case TRUNCATE_RULE: {
                    return SubstringRule.truncateRule(config, originalData);
                }
            }
            return originalData;
        }
        catch (Exception e) {
            logger.info("truncated string error. config:{},string:{}", (Object)JSONObject.toJSONString((Object)ruleConfig), (Object)originalData);
            return originalData;
        }
    }

    private static String holdRule(SubstringConfig config, String originalData) {
        int n = config.getStartIndex();
        int m = config.getEndIndex();
        if (n > originalData.length()) {
            return "";
        }
        return m > (originalData = originalData.substring(n - 1)).length() ? originalData : originalData.substring(0, m - n + 1);
    }

    private static String truncateRule(SubstringConfig config, String originalData) {
        int n = config.getStartIndex();
        int m = config.getEndIndex();
        if (n > originalData.length()) {
            return originalData;
        }
        String originalDataFirst = originalData.substring(0, n - 1);
        if (m >= originalData.length()) {
            return originalDataFirst;
        }
        String originalDataSec = originalData.substring(m + 1);
        return originalDataFirst + originalDataSec;
    }
}

