/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.exceptions.BusinessException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class AesUtils {
    private static SecretKeySpec AES_PASSWORD;
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static SecretKey generateAESKeySecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
            keyGenerator.init(128);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public static String generateAESKey() {
        SecretKey SecretKey2 = AesUtils.generateAESKeySecretKey();
        return Base64.getEncoder().encodeToString(SecretKey2.getEncoded());
    }

    public static String encryptAES(String plainText, String aesSecretKey) {
        try {
            return AesUtils.encrypt(plainText, new SecretKeySpec(aesSecretKey.getBytes(), KEY_ALGORITHM));
        }
        catch (Exception e) {
            return plainText;
        }
    }

    public static String decryptAES(String plainText, String aesSecretKey) {
        try {
            return AesUtils.decrypt(plainText, new SecretKeySpec(aesSecretKey.getBytes(), KEY_ALGORITHM));
        }
        catch (Exception e) {
            return plainText;
        }
    }

    public static String encrypt(String plainText, SecretKey secretKey) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, secretKey);
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes());
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String decrypt(String encryptedText, SecretKey secretKey) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, secretKey);
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedText);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return new String(decryptedBytes);
    }

    public static String encrypt(String content, String secretKey) {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, AesUtils.getSecretKey(secretKey));
            byte[] encrypted = cipher.doFinal(content.getBytes("utf-8"));
            return new BASE64Encoder().encode(encrypted);
        }
        catch (Exception ex) {
            return content;
        }
    }

    public static String decrypt(String content, String secretKey) {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, AesUtils.getSecretKey(secretKey));
            byte[] base64Data = new BASE64Decoder().decodeBuffer(content);
            byte[] original = cipher.doFinal(base64Data);
            String originalString = new String(original, "utf-8");
            return originalString;
        }
        catch (Exception ex) {
            return content;
        }
    }

    private static SecretKeySpec getSecretKey(String password) throws Exception {
        if (AES_PASSWORD != null) {
            return AES_PASSWORD;
        }
        try {
            byte[] keyBytes = Arrays.copyOf(password.getBytes("ASCII"), 16);
            AES_PASSWORD = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
            return AES_PASSWORD;
        }
        catch (Exception ex) {
            throw new Exception("\u52a0\u5bc6\u79d8\u94a5\u5931\u8d25");
        }
    }
}

