/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.dto.daas.DaasApiDTO;
import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.enums.DataCatalogClassificationType;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.TDsApi;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.ds.TDsAssetsOperationRecord;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import feign.Request;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@ConditionalOnProperty(name={"data.assets.enable"}, havingValue="true", matchIfMissing=true)
public class DataServiceProcessor
extends DataAssetsBaseProcessor<DaasApiDTO> {
    private static final Logger log = LoggerFactory.getLogger(DataServiceProcessor.class);
    private final DsService dsService;
    private final DaasService daasService;

    @Override
    public void save(DaasApiDTO daasApiDTO) {
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(daasApiDTO.getId());
        dataAssetsVO.setName(daasApiDTO.getDisplayName());
        dataAssetsVO.setCode(daasApiDTO.getApiName());
        dataAssetsVO.setCreateTime(new Date());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_API.getCode());
        dataAssetsVO.setTenantId(daasApiDTO.getTenantId());
        String key = String.valueOf(daasApiDTO.getId()).concat("_").concat(DataCatalogClassificationType.DATA_API.name());
        this.dataSaveEs(key, dataAssetsVO);
    }

    @Override
    public void bindCatalog(DaasApiDTO daasApiDTO) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(daasApiDTO.getId()).catalogIds(daasApiDTO.getCatalogIds()).classificationType(DataCatalogClassificationType.DATA_API.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void unbindCatalog(Object[] args) {
        Integer id = Integer.valueOf(String.valueOf(args[0]));
        this.unbindCatalogById(id);
    }

    private void unbindCatalogById(Integer id) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(id).classificationType(DataCatalogClassificationType.DATA_API.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void update(DaasApiDTO daasApiDTO) {
        if (StringUtils.isEmpty(daasApiDTO.getApiName())) {
            log.warn("dont need to update");
            return;
        }
        this.remove(daasApiDTO.getId());
        this.save(daasApiDTO);
    }

    @Override
    public void remove(Object obj) {
        String id = String.valueOf(obj).concat("_").concat(DataCatalogClassificationType.DATA_API.name());
        this.dataRemoveEs(id);
        if (!ObjectUtils.isEmpty((Object)obj)) {
            this.unbindCatalogById(Integer.valueOf(String.valueOf(obj)));
        }
    }

    @Override
    public DaasApiDTO getToEsArgs(Object ... dataParam) {
        UserInfo userInfo = UserInfoContext.getContext();
        Object[] args = (Object[])dataParam[0];
        DaasApiDTO daasApiDTO = JSONUtils.parseObject(JSONUtils.toJson(args[0]), DaasApiDTO.class);
        if (daasApiDTO.getId() == null) {
            daasApiDTO.setId(this.getDataIdByResult(dataParam[1]));
        }
        daasApiDTO.setTenantId(userInfo.getTenantId());
        return daasApiDTO;
    }

    @Override
    public Integer getDataId(Object ... dataParam) {
        DaasApiDTO daasApiDTO = this.getToEsArgs(dataParam);
        return daasApiDTO.getId();
    }

    @Override
    public Integer getRemoveDataId(Object ... dataParam) {
        Object[] args = (Object[])dataParam[0];
        Integer dataId = Integer.valueOf(String.valueOf(args[0]));
        return dataId;
    }

    @Override
    public void compensateAssetsToEsErrorDataSave(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        TDsApi tDsApi = this.queryApiById(tDsAssetsOperationRecord.getDataId());
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(tDsApi.getId());
        dataAssetsVO.setName(tDsApi.getDisplayName());
        dataAssetsVO.setCode(tDsApi.getApiName());
        dataAssetsVO.setCreateTime(tDsAssetsOperationRecord.getOperationTime());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_API.getCode());
        dataAssetsVO.setTenantId(tDsApi.getTenantId());
        String key = String.valueOf(tDsApi.getId()).concat("_").concat(DataCatalogClassificationType.DATA_API.name());
        this.dataSaveEs(key, dataAssetsVO);
    }

    public TDsApi queryApiById(Integer dataId) {
        Result<TDsApi> apiResult = this.daasService.apiQueryDetailsById(dataId);
        Optional.ofNullable(apiResult).ifPresent(tDsApiResult -> {
            if (!tDsApiResult.getCode().equals(Status.SUCCESS.getCode())) {
                log.error("query daas api info error\uff01errorInfo:{}", (Object)tDsApiResult.getMsg());
                throw new BusinessException(Status.QUERY_API_ERROR);
            }
        });
        return apiResult.getData();
    }

    @Override
    public void compensateAssetsToEsErrorDataUpdate(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        this.compensateAssetsToEsErrorDataDelete(tDsAssetsOperationRecord);
        this.compensateAssetsToEsErrorDataSave(tDsAssetsOperationRecord);
    }

    @Override
    public void compensateAssetsToEsErrorDataDelete(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
        String id = String.valueOf(tDsAssetsOperationRecord.getDataId()).concat("_").concat(DataCatalogClassificationType.DATA_API.name());
        this.dataRemoveEs(id);
    }

    @Autowired
    public DataServiceProcessor(DsService dsService, DaasService daasService) {
        this.dsService = dsService;
        this.daasService = daasService;
    }
}

