/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.utils.StringUtils;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileValidator {
    private static final Logger log = LoggerFactory.getLogger(FileValidator.class);
    private static final String FILENAME_REGEX = "^[^\\\\/]+\\.(xls|xlsx|csv)$";
    private static final long MAX_FILE_SIZE = 0xA00000L;

    public boolean validateFileFormat(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        String fileExtension = FilenameUtils.getExtension((String)originalFilename);
        if (StringUtils.isBlank(fileExtension)) {
            log.info("fileExtension is empty");
            throw new BusinessException(Status.FILE_EXTENSION_IS_EMPTY);
        }
        return "xls".equals(fileExtension = fileExtension.toLowerCase()) || "xlsx".equals(fileExtension) || "csv".equals(fileExtension);
    }

    public boolean validateFilenameSecurity(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        if (originalFilename != null) {
            return Pattern.matches(FILENAME_REGEX, originalFilename);
        }
        return false;
    }

    public boolean validateFileSize(MultipartFile file) {
        return file.getSize() <= 0xA00000L;
    }

    public void validate(MultipartFile file) {
        if (!this.validateFileFormat(file)) {
            throw new BusinessException(Status.FILE_FORMAT_IS_INVALID);
        }
        if (!this.validateFilenameSecurity(file)) {
            throw new BusinessException(Status.FILE_NAME_IS_NOT_SECURITY);
        }
        if (!this.validateFileSize(file)) {
            throw new BusinessException(Status.FILE_EXCEEDING_THE_LIMIT_SIZE);
        }
    }
}

