/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.context;

public class TokenContext {
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();
    private static final ThreadLocal<String> tokenContextHolder = new ThreadLocal();
    private static final ThreadLocal<String> iamAuthAppHolder = new ThreadLocal();
    private static final ThreadLocal<String> iamAuthUserHolder = new ThreadLocal();

    TokenContext() {
    }

    public static void clearContext() {
        contextHolder.remove();
    }

    public static String getContext() {
        String ctx = contextHolder.get();
        if (ctx == null) {
            ctx = TokenContext.createEmptyContext();
            contextHolder.set(ctx);
        }
        return ctx;
    }

    public static void setContext(String context) {
        contextHolder.set(context);
    }

    public static String getTokenContext() {
        String ctx = tokenContextHolder.get();
        if (ctx == null) {
            ctx = TokenContext.createEmptyContext();
            tokenContextHolder.set(ctx);
        }
        return ctx;
    }

    public static void setTokenContext(String token) {
        contextHolder.set(token);
    }

    public static void setIamAuthAppContext(String context) {
        iamAuthAppHolder.set(context);
    }

    public static String getIamAuthAppContext() {
        String ctx = iamAuthAppHolder.get();
        if (ctx == null) {
            ctx = TokenContext.createEmptyContext();
            iamAuthAppHolder.set(ctx);
        }
        return ctx;
    }

    public static void setIamAuthUserContext(String context) {
        iamAuthUserHolder.set(context);
    }

    public static String getIamAuthUserContext() {
        String ctx = iamAuthUserHolder.get();
        if (ctx == null) {
            ctx = TokenContext.createEmptyContext();
            iamAuthUserHolder.set(ctx);
        }
        return ctx;
    }

    public static String createEmptyContext() {
        return "";
    }
}

