/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.context;

import com.digiwin.commons.context.SpringApplicationContext;
import com.digiwin.commons.entity.model.iam.IamUserCache;
import com.digiwin.commons.startup.TDapIamUserCacheService;
import com.digiwin.commons.utils.StringUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class IamUserCacheContext {
    private static final Logger log = LoggerFactory.getLogger(IamUserCacheContext.class);
    private static final Cache<Long, String> USER_CACHE = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public static void refreshCacheName(Long userId, String name) {
        if (StringUtils.isNotBlank(name)) {
            USER_CACHE.put((Object)userId, (Object)name);
        }
    }

    public static String getCacheName(Long userId) {
        return (String)USER_CACHE.getIfPresent((Object)userId);
    }

    public static String queryUserNameByCache(Long userId) {
        if (ObjectUtils.isEmpty((Object)userId)) {
            return "";
        }
        String cacheName = IamUserCacheContext.getCacheName(userId);
        if (StringUtils.isNotBlank(cacheName)) {
            return cacheName;
        }
        TDapIamUserCacheService tDapIamUserCacheService = SpringApplicationContext.getBean(TDapIamUserCacheService.class);
        IamUserCache iamUserCache = tDapIamUserCacheService.selectByCodeOfNullBuild(userId);
        if (!ObjectUtils.isEmpty((Object)iamUserCache)) {
            IamUserCacheContext.refreshCacheName(userId, iamUserCache.getName());
            return iamUserCache.getName();
        }
        return "";
    }
}

