/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils
extends DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    public static String currentParse(String parse) {
        SimpleDateFormat sdf = new SimpleDateFormat(parse);
        String format = sdf.format(DateUtils.current());
        return format;
    }

    public static List<String> getCurrentDatePreDate(Integer preDay, String format) {
        DateTime currentDateTime = DateUtils.date();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = preDay - 1; i >= 0; --i) {
            DateTime date = DateUtil.offsetDay((Date)currentDateTime, (int)(-i));
            String formattedDate = DateUtil.format((Date)date, (String)format);
            list.add(formattedDate);
        }
        return list;
    }

    public static Long getCurrTimeStamp() {
        return new Date().getTime() / 1000L;
    }

    public static String getPreHourDate(String currentDate, Integer hourCount, String formatPattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatPattern);
        String newDateString = "";
        try {
            Date date = sdf.parse(currentDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(10, hourCount);
            Date newDate = calendar.getTime();
            newDateString = sdf.format(newDate);
        }
        catch (Exception e) {
            log.error("date format error!e:{}", (Throwable)e);
        }
        return newDateString;
    }

    public static List<String> getTimeHourList(String startTime, String endTime, String formatPattern, String returnFormatPattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatPattern);
        SimpleDateFormat hoursOnlySdf = new SimpleDateFormat(returnFormatPattern);
        ArrayList<String> hourList = new ArrayList<String>();
        try {
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            while (calendar.getTime().before(endDate)) {
                hourList.add(hoursOnlySdf.format(calendar.getTime()));
                calendar.add(10, 1);
            }
        }
        catch (Exception e) {
            log.error("date format error!e:{}", (Throwable)e);
        }
        return hourList;
    }
}

