/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.model.datasource;

import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.utils.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataSource {
    private static final Logger logger = LoggerFactory.getLogger(BaseDataSource.class);
    protected String user;
    protected String password;
    private String address;
    private String database;
    private String other;
    private String principal;
    private Integer type;
    private String memory;
    private Integer connectTimeout;

    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public abstract String driverClassSelector();

    public abstract DbType dbTypeSelector();

    public String getJdbcUrl() {
        StringBuilder jdbcUrl = new StringBuilder(this.getAddress());
        this.appendDatabase(jdbcUrl);
        this.appendPrincipal(jdbcUrl);
        this.appendOther(jdbcUrl);
        return jdbcUrl.toString();
    }

    protected void appendDatabase(StringBuilder jdbcUrl) {
        if (this.dbTypeSelector() == DbType.SQLSERVER) {
            jdbcUrl.append(";databaseName=").append(this.getDatabase());
        } else {
            if (this.getAddress().lastIndexOf(47) != jdbcUrl.length() - 1) {
                jdbcUrl.append("/");
            }
            jdbcUrl.append(this.getDatabase());
        }
    }

    private void appendPrincipal(StringBuilder jdbcUrl) {
        boolean tag;
        boolean bl = tag = this.dbTypeSelector() == DbType.HIVE || this.dbTypeSelector() == DbType.SPARK;
        if (tag && StringUtils.isNotEmpty(this.getPrincipal())) {
            jdbcUrl.append(";principal=").append(this.getPrincipal());
        }
    }

    private void appendOther(StringBuilder jdbcUrl) {
        String otherParams = this.filterOther(this.getOther());
        if (StringUtils.isNotEmpty(otherParams)) {
            String separator = "";
            switch (this.dbTypeSelector()) {
                case CLICKHOUSE: 
                case MYSQL: 
                case ORACLE: 
                case POSTGRESQL: {
                    separator = "?";
                    break;
                }
                case DB2: {
                    separator = ":";
                    break;
                }
                case HIVE: 
                case SPARK: 
                case SQLSERVER: {
                    separator = ";";
                    break;
                }
                default: {
                    logger.error("Db type mismatch!");
                }
            }
            jdbcUrl.append(separator).append(otherParams);
        }
    }

    public Connection getConnection() throws Exception {
        Class.forName(this.driverClassSelector());
        return DriverManager.getConnection(this.getJdbcUrl(), this.getUser(), this.getPassword());
    }

    protected String filterOther(String otherParams) {
        return otherParams;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTopTenDataSql(String column, String tableCode) {
        String sql = "select " + column + " from " + tableCode + " limit " + "10";
        return sql;
    }
}

