/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.vo.ResourceConsumptionVo;
import com.digiwin.commons.utils.CollectionsUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class OshiUtils {
    private static final Logger log = LoggerFactory.getLogger(OshiUtils.class);
    private static final int STORE_UNIT = 0x40000000;

    public static ResourceConsumptionVo getResourceConsumption(int pid) {
        BigDecimal memoryAmount;
        BigDecimal cpuAmount;
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem os = systemInfo.getOperatingSystem();
        Predicate<OSProcess> filter = process -> process.getParentProcessID() == pid || process.getProcessID() == pid;
        Comparator<OSProcess> sort = Comparator.comparingInt(OSProcess::getProcessID);
        List processes = os.getProcesses(filter, sort, 100);
        ResourceConsumptionVo vo = new ResourceConsumptionVo();
        if (CollectionsUtils.notEmpty(processes).booleanValue()) {
            cpuAmount = new BigDecimal(0);
            memoryAmount = new BigDecimal(0);
            for (OSProcess osProcess : processes) {
                cpuAmount = cpuAmount.add(BigDecimal.valueOf(osProcess.getProcessCpuLoadCumulative()));
                memoryAmount = memoryAmount.add(BigDecimal.valueOf(osProcess.getResidentSetSize()));
            }
        } else {
            log.info("\u4f20\u5165\u7684\u8fdb\u7a0bid\u4e3a\u7a7a");
            return vo;
        }
        memoryAmount = memoryAmount.divide(BigDecimal.valueOf(0x40000000L), 2, RoundingMode.HALF_UP);
        vo.setCpuAmount(cpuAmount);
        vo.setMemoryAmount(memoryAmount);
        return vo;
    }
}

