/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.vo.ResourceConsumptionVo;
import com.digiwin.commons.utils.CollectionsUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class OshiUtils {
    private static final Logger log = LoggerFactory.getLogger(OshiUtils.class);
    private static final int STORE_UNIT = 1024;

    public static ResourceConsumptionVo getResourceConsumption(List<Integer> pidList) {
        BigDecimal memoryAmount;
        BigDecimal cpuAmount;
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem os = systemInfo.getOperatingSystem();
        ResourceConsumptionVo vo = new ResourceConsumptionVo();
        if (CollectionsUtils.notEmpty(pidList).booleanValue()) {
            cpuAmount = new BigDecimal(0);
            memoryAmount = new BigDecimal(0);
            OperatingSystem operatingSystem = systemInfo.getOperatingSystem();
            List processList = operatingSystem.getProcesses(pidList);
            for (OSProcess osProcess : processList) {
                cpuAmount = cpuAmount.add(BigDecimal.valueOf(osProcess.getProcessCpuLoadCumulative()));
            }
            for (Integer pid : pidList) {
                OSProcess process = os.getProcess(pid.intValue());
                memoryAmount = memoryAmount.add(BigDecimal.valueOf(process.getResidentSetSize()));
            }
        } else {
            log.info("\u4f20\u5165\u7684\u8fdb\u7a0bid\u4e3a\u7a7a");
            return vo;
        }
        memoryAmount = memoryAmount.divide(BigDecimal.valueOf(1024L), 2, RoundingMode.HALF_UP);
        vo.setCpuAmount(cpuAmount);
        vo.setMemoryAmount(memoryAmount);
        return vo;
    }
}

