/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.digiwin.commons.annotation.EnumDict;
import com.digiwin.commons.utils.StringUtils;

public enum TaskType {
    SHELL(0, "shell"),
    SQL(1, "sql"),
    SUB_PROCESS(2, "sub_process"),
    PROCEDURE(3, "procedure"),
    MR(4, "mr"),
    SPARK(5, "spark"),
    PYTHON(6, "python"),
    DEPENDENT(7, "dependent"),
    FLINK(8, "flink"),
    HTTP(9, "http"),
    DATAX(10, "datax"),
    CONDITIONS(11, "conditions"),
    SQOOP(12, "sqoop"),
    GATEWAY(13, "gateway"),
    API_SYNC(14, "api_sync"),
    CDC_SYNC(15, "cdc_sync"),
    ESP_SYNC(16, "esp_sync"),
    DATA_QUALITY(17, "data_quality"),
    STARROCKS_SQL(18, "starrocks_sql"),
    HIVE_SQL(19, "hive_sql"),
    CDC_PATH(44, "$.tasks[type='CDC_SYNC']");

    @EnumValue
    @EnumDict(value=0)
    private final int code;
    @EnumDict(value=1)
    private final String descp;

    private TaskType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static boolean typeIsNormalTask(String typeName) {
        TaskType taskType = TaskType.valueOf(typeName);
        return taskType != SUB_PROCESS && taskType != DEPENDENT;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static boolean checkCustomType(String name) {
        if (StringUtils.isNotBlank(name)) {
            return false;
        }
        return TaskType.checkCustomType(TaskType.valueOf((String)name.toLowerCase()).code);
    }

    public static boolean checkCustomType(Integer number) {
        if (number == null) {
            return false;
        }
        return number > 12 && number != 18;
    }
}

