/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.security;

import com.digiwin.commons.entity.enums.DataSecurityRuleDirection;
import com.digiwin.commons.entity.enums.ReplaceTemplateType;
import com.digiwin.commons.entity.model.security.ReplaceRuleConfig;
import com.digiwin.commons.entity.model.security.TDsDataSecurityRuleConfig;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceRule {
    public static final Logger logger = LoggerFactory.getLogger(ReplaceRule.class);

    public static String replaceFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData) {
        ReplaceRuleConfig config = (ReplaceRuleConfig)ruleConfig;
        ReplaceTemplateType hideTemplateType = config.getReplaceTemplateType();
        if (ReplaceTemplateType.RANDOM_VALUE_REPLACEMENT.equals((Object)hideTemplateType)) {
            config.setReplaceStr(ReplaceRule.generateRandomChar(config));
        }
        return ReplaceRule.fixedValueReplacement(config, originalData);
    }

    public static String fixedValueReplacement(ReplaceRuleConfig config, String originalData) {
        int atIndex = originalData.indexOf(config.getReplaceLocation());
        if (atIndex == -1) {
            return originalData;
        }
        DataSecurityRuleDirection direction = config.getDirection();
        int startIndex = 0;
        int endIndex = 0;
        switch (direction) {
            case BEFORE_THE_CHARACTER: {
                endIndex = atIndex;
                break;
            }
            case AFTER_THE_CHARACTER: {
                startIndex = atIndex + config.getReplaceLocation().length();
                endIndex = originalData.length();
                break;
            }
            case ALL_THE_CHARACTER: {
                return originalData.replace(config.getReplaceLocation(), config.getReplaceStr());
            }
        }
        StringBuilder stringBuilder = new StringBuilder(originalData);
        ReplaceRule.stringBuilderReplace(stringBuilder, startIndex, endIndex, config.getReplaceStr());
        return stringBuilder.toString();
    }

    public static String generateRandomChar(ReplaceRuleConfig config) {
        int length = config.getReplaceDigits();
        String characters = config.getReplaceType().getCharValue();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomIndex = new Random().nextInt(characters.length());
            sb.append(characters.charAt(randomIndex));
        }
        return sb.toString();
    }

    private static StringBuilder stringBuilderReplace(StringBuilder stringBuilder, int start, int end, String str) {
        try {
            stringBuilder.replace(start, end, str);
        }
        catch (Exception e) {
            return stringBuilder;
        }
        return stringBuilder;
    }
}

