/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.digiwin.commons.annotation.EnumDict;
import com.digiwin.commons.exceptions.BusinessException;
import org.springframework.util.ObjectUtils;

public enum ApiType {
    SCRIPT(1, "\u811a\u672c\u6a21\u5f0f"),
    GUIDE(0, "\u6570\u636e\u5171\u4eabAPI\uff08\u5355\u8868\u5411\u5bfc\uff09"),
    CUBE(2, "DataCube API\uff08\u591a\u8868\u5411\u5bfc\uff09");

    @EnumValue
    @EnumDict(value=0)
    private final int code;
    @EnumValue
    @EnumDict(value=1)
    private final String name;

    private ApiType(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static ApiType of(Integer apiType) {
        if (ObjectUtils.isEmpty((Object)apiType)) {
            throw new BusinessException("api type is empty");
        }
        for (ApiType type : ApiType.values()) {
            if (type.getCode() != apiType.intValue()) continue;
            return type;
        }
        throw new IllegalArgumentException("invalid api type : " + apiType);
    }
}

