/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.dcc.core.entity.query.PlaygroundHierarchyDataDto;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyDataUtils {
    private static final Logger logger = LoggerFactory.getLogger(HierarchyDataUtils.class);
    private static final String UNIQUE_PATH_SYMBOL = "96fab797-3c01-4d58-b481-69d21b913fab";
    private static final String CHILDREN_NAME = "hierarchyChildren";

    private HierarchyDataUtils() {
        throw new IllegalStateException("HierarchyDataUtils class");
    }

    public static List<Map<String, Object>> getHierarchyData(PlaygroundHierarchyDataDto hierarchyData, List<Map<String, Object>> dataList) {
        HashMap resultDataMap = new HashMap();
        dataList.forEach(data -> HierarchyDataUtils.hierarchyItem(null, hierarchyData, data, resultDataMap));
        List<Map<String, Object>> resultList = resultDataMap.entrySet().stream().filter(f -> !((String)f.getKey()).contains(UNIQUE_PATH_SYMBOL)).map(m -> (LinkedHashMap)m.getValue()).collect(Collectors.toList());
        return resultList;
    }

    public static void hierarchyItem(String parentUniquePath, PlaygroundHierarchyDataDto hierarchy, Map<String, Object> item, Map<String, LinkedHashMap<String, Object>> resultDataMap) {
        if (null == hierarchy || CollectionUtil.isEmpty((Collection)hierarchy.getFields())) {
            return;
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < hierarchy.getFields().size(); ++i) {
            String field = (String)hierarchy.getFields().get(i);
            dataMap.put(field, item.get(field));
        }
        String uniquePath = HierarchyDataUtils.getUniquePath(parentUniquePath, dataMap.values());
        LinkedList resList = new LinkedList();
        dataMap.put(CHILDREN_NAME, resList);
        if (resultDataMap.putIfAbsent(uniquePath, dataMap) == null && null != parentUniquePath) {
            LinkedHashMap<String, Object> parentData = resultDataMap.get(parentUniquePath);
            LinkedList siblingList = (LinkedList)parentData.get(CHILDREN_NAME);
            siblingList.add(dataMap);
        }
        HierarchyDataUtils.hierarchyItem(uniquePath, hierarchy.getChild(), item, resultDataMap);
    }

    private static String getUniquePath(String parentUniquePath, Collection<Object> dataList) {
        String uniquePath = StringUtils.join(dataList, (String)",");
        return null != parentUniquePath ? parentUniquePath + UNIQUE_PATH_SYMBOL + uniquePath : uniquePath;
    }
}

