/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.datasource;

import com.digiwin.commons.datasource.BaseDataSource;
import com.digiwin.commons.entity.enums.DbType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerDataSource
extends BaseDataSource {
    private static final Logger logger = LoggerFactory.getLogger(SQLServerDataSource.class);

    @Override
    public String getJdbcUrl() {
        String jdbcUrl = this.getAddress();
        jdbcUrl = jdbcUrl + ";databaseName=" + this.getDatabase();
        if (StringUtils.isNotEmpty((String)this.getOther())) {
            jdbcUrl = jdbcUrl + ";" + this.getOther();
        }
        return jdbcUrl;
    }

    @Override
    public String driverClassSelector() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public DbType dbTypeSelector() {
        return DbType.SQLSERVER;
    }
}

