/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.components.DmpInvokeRecordThreadPool;
import com.digiwin.commons.context.SpringApplicationContext;
import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.constant.IamConstant;
import com.digiwin.commons.entity.dto.LoginDTO;
import com.digiwin.commons.entity.dto.iam.IamAesKeyDTO;
import com.digiwin.commons.entity.dto.iam.IamLoginDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgAspectDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgUserDTO;
import com.digiwin.commons.entity.dto.iam.IamRoleDTO;
import com.digiwin.commons.entity.dto.iam.IamTenantDTO;
import com.digiwin.commons.entity.dto.iam.IamTenantUserDTO;
import com.digiwin.commons.entity.dto.iam.IamUserBaseSIdDTO;
import com.digiwin.commons.entity.dto.iam.IamUserDTO;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.enums.UserType;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.ds.dmp.TDmpInvokeApiInfoRecord;
import com.digiwin.commons.entity.model.iam.IamAesPublicKy;
import com.digiwin.commons.entity.model.iam.IamAnalyzeToken;
import com.digiwin.commons.entity.model.iam.IamAssociationUserInRole;
import com.digiwin.commons.entity.model.iam.IamAuthoredUser;
import com.digiwin.commons.entity.model.iam.IamLoginUser;
import com.digiwin.commons.entity.model.iam.IamOrgAspect;
import com.digiwin.commons.entity.model.iam.IamPermissionUser;
import com.digiwin.commons.entity.model.iam.IamPermissions;
import com.digiwin.commons.entity.model.iam.IamPublicKey;
import com.digiwin.commons.entity.model.iam.IamResult;
import com.digiwin.commons.entity.model.iam.IamRoles;
import com.digiwin.commons.entity.model.iam.IamTenant;
import com.digiwin.commons.entity.model.iam.IamTenantUser;
import com.digiwin.commons.entity.model.iam.IamUserByToken;
import com.digiwin.commons.entity.model.iam.IamUserTenantList;
import com.digiwin.commons.entity.vo.daas.QueryIamAppListVo;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.feign.client.IamService;
import com.digiwin.commons.service.IamBusinessService;
import com.digiwin.commons.utils.CollectionsUtils;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import com.digiwin.commons.utils.iam.AESUtils;
import com.digiwin.commons.utils.iam.RSAUtils;
import feign.Request;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnProperty(name={"iam.feign.enable"}, havingValue="true")
public class IamBusinessServiceImpl
implements IamBusinessService {
    private static final Logger log = LoggerFactory.getLogger(IamBusinessServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Value(value="${dmp.env}")
    private String dmpEnv;
    @Value(value="${dmp.default.tenant:digiwnDMP}")
    private String dmpDefaultTenant;
    @Value(value="${dmp.tenant-name-rule.prefix}")
    private String dmpTenantNameRulePrefix;
    @Value(value="${dmp.tenant-name-rule.suffix}")
    private String dmpTenantNameRuleSuffix;
    @Value(value="${dmp.tenant-name-rule.white}")
    private String dmpTenantNameRuleWhite;
    @Value(value="${iam.app-id}")
    private String appId;
    @Value(value="${ds.api.user:integration}")
    private String apiUser;
    @Value(value="${ds.api.password:6826CC688C4AF1BD0A8DDA2DBDF8897B}")
    private String apiPassword;
    private final String INTERGRATION_ID = "integration";

    @Override
    public List<UserInfo> queryUserInfoByNameContent(IamTenantUserDTO iamTenantUserDTO) {
        iamTenantUserDTO.setAppId(this.appId);
        log.info("invoke iam user info by name content params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        log.info("invoke iam user info by name content response:{}", (Object)JSONUtils.toJson(iamTenantUserResult));
        return iamTenantUserResult.getData().getList().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
    }

    @Override
    public IamResult<IamTenantUser> queryUserInfoByNameContentResult(IamTenantUserDTO iamTenantUserDTO) {
        iamTenantUserDTO.setAppId(this.appId);
        log.debug("invoke iam user info by name content params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        log.debug("invoke iam user info by name content response:{}", (Object)JSONUtils.toJson(iamTenantUserResult));
        return iamTenantUserResult;
    }

    @Override
    public Optional<UserInfo> queryUserInfoByName(String userName) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userName(userName).build();
        iamTenantUserDTO.setAppId(this.appId);
        log.debug("invoke iam user info by name params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        log.debug("invoke iam user info by name response:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        if (CollectionUtils.isEmpty(iamTenantUserResult.getData().getList())) {
            return Optional.empty();
        }
        UserInfo userInfo = (UserInfo)iamTenantUserResult.getData().getList().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList()).get(0);
        return Optional.of(userInfo);
    }

    @Override
    public boolean checkUserSidByNameIsEmpty(String userContent, IamUserBaseSIdDTO iamUserBaseSIdDTO) {
        if (StringUtils.isBlank(userContent)) {
            log.info("param user content is empty");
            iamUserBaseSIdDTO.setSidList(Collections.emptyList());
            return false;
        }
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userContent(userContent).build();
        List<Long> sIdList = this.queryUserInfoByNameContent(iamTenantUserDTO).stream().map(UserInfo::getSid).collect(Collectors.toList());
        iamUserBaseSIdDTO.setSidList(sIdList);
        return CollectionUtils.isEmpty(sIdList);
    }

    @Override
    public Optional<UserInfo> queryUserInfoBySid(Long sid) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userSids(Collections.singletonList(sid)).build();
        log.debug("invoke iam user info by sid params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<List<IamUserByToken>> iamTenantUserIamResult = this.iamService.queryUserBySids(iamTenantUserDTO);
        log.debug("invoke iam user info by sid response:{}", (Object)JSONUtils.toJson(iamTenantUserIamResult));
        if (CollectionsUtils.notEmpty(iamTenantUserIamResult.getData()).booleanValue()) {
            List userInfoList = iamTenantUserIamResult.getData().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
            return Optional.of(userInfoList.get(0));
        }
        return Optional.empty();
    }

    @Override
    public List<UserInfo> queryBatchUserInfoBySidList(List<Long> userSid) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userSids(userSid).build();
        log.debug("invoke iam user info by sid params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        log.info("auth-app {}, auth-user {}", (Object)TokenContext.getIamAuthAppContext(), (Object)TokenContext.getIamAuthUserContext());
        Object obj = this.iamService.queryUserBySidsResultObject(iamTenantUserDTO);
        log.debug("iam query user by sid obj info :{}", obj);
        JSONObject jsonObject = JSONUtils.parseObject(JSONUtils.toJson(obj));
        log.debug("iam query user by sid obj info json :{}", (Object)jsonObject);
        List<IamUserByToken> data = JSONUtils.toList(jsonObject.getString("data"), IamUserByToken.class);
        log.debug("iam query user data info :{}", (Object)JSONUtils.toJson(data));
        if (CollectionsUtils.notEmpty(data).booleanValue()) {
            List<UserInfo> userInfoList = data.stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
            log.info("user info list:{}", (Object)JSONUtils.toJson(userInfoList));
            IamRoleDTO iamRoleDTO = IamRoleDTO.builder().roleId(IamConstant.IAM_SUPER_ADMIN_IDENTIFY).status(2).build();
            List<IamAssociationUserInRole> iamAssociationUserInRoles = this.queryAssociationUserInRole(iamRoleDTO);
            if (!CollectionUtils.isEmpty(iamAssociationUserInRoles) && !CollectionUtils.isEmpty(userInfoList)) {
                List adminUserSidList = iamAssociationUserInRoles.stream().map(IamAssociationUserInRole::getSid).collect(Collectors.toList());
                userInfoList.forEach(userInfo -> {
                    if (adminUserSidList.contains(userInfo.getSid())) {
                        userInfo.setUserType(UserType.ADMIN_USER);
                    } else {
                        userInfo.setUserType(UserType.GENERAL_USER);
                    }
                });
            }
            log.info("user info return list:{}", (Object)JSONUtils.toJson(userInfoList));
            return userInfoList;
        }
        return new ArrayList<UserInfo>();
    }

    @Override
    public IamLoginUser login(IamLoginDTO iamLoginDTO) {
        iamLoginDTO.setIdentityType("token");
        log.debug("invoke iam login params:{}", (Object)JSONUtils.toJson(iamLoginDTO));
        IamLoginUser loginUser = this.iamService.login(iamLoginDTO, new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
        log.debug("invoke iam login response param:{}", (Object)JSONUtils.toJson(loginUser));
        TokenContext.setIamAuthAppContext(IamConstant.DIGI_MIDDLEWARE_AUTH_APP);
        TokenContext.setIamAuthUserContext(loginUser.getToken());
        if (loginUser.getUserId().equals("integration")) {
            loginUser.setUserType(UserType.ADMIN_USER);
        } else {
            boolean adminFlag;
            IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission(new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
            List<IamRoles> roles = iamPermissionUser.getResult().getRoles();
            loginUser.setUserType(UserType.GENERAL_USER);
            if (CollectionsUtils.notEmpty(roles).booleanValue() && (adminFlag = roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId())))) {
                loginUser.setUserType(UserType.ADMIN_USER);
            }
        }
        this.buildLoginUserInfoByToken(iamLoginDTO, loginUser);
        return loginUser;
    }

    @Override
    public boolean isAdmin() {
        IamUserByToken iamUserByToken = this.iamService.queryIamUserInfoByUserToken();
        if (iamUserByToken != null && StringUtils.isNotBlank(iamUserByToken.getId()) && iamUserByToken.getId().equals("integration")) {
            return true;
        }
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission(new Request.Options(5L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
        log.debug("invoke iam user permission info response:{}", (Object)JSONUtils.toJson(iamPermissionUser));
        if (ObjectUtils.isEmpty((Object)iamPermissionUser)) {
            log.error("query iam permission user is null!");
            throw new BusinessException("query iam permission user is null!");
        }
        List<IamRoles> roles = iamPermissionUser.getResult().getRoles();
        if (!CollectionsUtils.notEmpty(roles).booleanValue()) {
            log.error("query iam permission user roles is empty");
            return false;
        }
        return roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId()));
    }

    @Override
    public UserType isAdminUserType() {
        boolean adminFlag = this.isAdmin();
        if (adminFlag) {
            return UserType.ADMIN_USER;
        }
        return UserType.GENERAL_USER;
    }

    @Override
    public List<IamPermissions> queryUserPermissionAll() {
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission(new Request.Options(5L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
        log.debug("invoke iam user permission info response:{}", (Object)JSONUtils.toJson(iamPermissionUser));
        List<IamPermissions> permissions = iamPermissionUser.getResult().getPermissions();
        UserInfo loginUser = UserInfoContext.getContext();
        String authAppToken = TokenContext.getIamAuthAppContext();
        String authUserToken = TokenContext.getIamAuthUserContext();
        String token = TokenContext.getTokenContext();
        DmpInvokeRecordThreadPool.executeTask(() -> {
            UserInfoContext.setContext(loginUser);
            TokenContext.setTokenContext(token);
            TokenContext.setIamAuthAppContext(authAppToken);
            TokenContext.setIamAuthUserContext(authUserToken);
            this.saveDmpInvokeApiRecord();
        });
        return permissions;
    }

    private void saveDmpInvokeApiRecord() {
        UserInfo loginUser = UserInfoContext.getContext();
        TDmpInvokeApiInfoRecord tDmpInvokeApiInfoRecord = TDmpInvokeApiInfoRecord.builder().url("/api/iam/v2/permission/user/all").appToken(loginUser.getAppToken()).userSid(loginUser.getSid()).userName(loginUser.getUserName()).tenantSid(loginUser.getTenantId()).createId(loginUser.getSid()).createTime(new Date()).build();
        DsService dsService = SpringApplicationContext.getBean(DsService.class);
        dsService.dmpInvokeApiRecordSave(tDmpInvokeApiInfoRecord);
    }

    @Override
    public IamUserTenantList queryUserEmailTenantsAuth(String userId) {
        IamUserDTO iamTenantDTO = IamUserDTO.builder().id(userId).type("0").tenantType(null).appId(this.appId).build();
        log.debug("invoke iam user permission info response:{}", (Object)JSONUtils.toJson(iamTenantDTO));
        IamResult<IamUserTenantList> iamUserTenantListIamResult = this.iamService.queryUserEmailTenantsAuth(iamTenantDTO);
        log.debug("invoke iam user permission info response:{}", (Object)JSONUtils.toJson(iamUserTenantListIamResult));
        return iamUserTenantListIamResult.getData();
    }

    @Override
    public List<IamTenant> queryTenantApps() {
        List<IamTenant> iamTenants = this.iamService.queryTenantApps(this.appId);
        return iamTenants;
    }

    @Override
    public IamTenant queryTenantBySid(Long sid) {
        IamLoginDTO iamLoginDTO = IamLoginDTO.builder().userId(this.apiUser).passwordHash(this.apiPassword).tenantSid(sid).build();
        IamLoginUser iamLoginUser = this.iamService.internalLogin(iamLoginDTO, new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
        IamTenant iamTenant = IamTenant.builder().sid(iamLoginUser.getTenantSid()).id(iamLoginUser.getTenantId()).name(iamLoginUser.getTenantName()).build();
        return iamTenant;
    }

    @Override
    public IamTenant queryTenantById(String tenantId) {
        IamLoginDTO iamLoginDTO = IamLoginDTO.builder().userId(this.apiUser).passwordHash(this.apiPassword).tenantId(tenantId).build();
        IamLoginUser iamLoginUser = this.iamService.internalLogin(iamLoginDTO, new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
        IamTenant iamTenant = IamTenant.builder().sid(iamLoginUser.getTenantSid()).id(iamLoginUser.getTenantId()).name(iamLoginUser.getTenantName()).build();
        return iamTenant;
    }

    private List<IamTenant> filterTenantInfo(List<IamTenant> iamTenantList) {
        List<IamTenant> list = new ArrayList<IamTenant>();
        switch (this.dmpEnv) {
            case "dev": 
            case "hw_demo": {
                list = iamTenantList.stream().filter(iamTenant -> iamTenant.getId().startsWith(this.dmpTenantNameRulePrefix) && iamTenant.getId().endsWith(this.dmpTenantNameRuleSuffix)).collect(Collectors.toList());
                break;
            }
            case "hw_test": 
            case "hw_prod": {
                list = iamTenantList.stream().filter(iamTenant -> !iamTenant.getId().startsWith(this.dmpTenantNameRulePrefix) || !iamTenant.getId().endsWith(this.dmpTenantNameRuleSuffix)).collect(Collectors.toList());
                break;
            }
            default: {
                list.addAll(iamTenantList);
            }
        }
        return list;
    }

    @Override
    public String replaceTenantIdPrefixAndSuffix(String tenantId) {
        log.info("set tenant id ,original value is : {}", (Object)tenantId);
        if (StringUtils.isEmpty(tenantId)) {
            return tenantId;
        }
        if (tenantId.equals(this.dmpTenantNameRuleWhite) && this.dmpEnv.equals("hw_demo")) {
            tenantId = this.dmpTenantNameRulePrefix.concat(tenantId).concat(this.dmpTenantNameRuleSuffix);
            log.info("set tenant id ,original value is : {}", (Object)tenantId);
        }
        switch (this.dmpEnv) {
            case "dev": 
            case "hw_demo": {
                if (tenantId.startsWith(this.dmpTenantNameRulePrefix) && tenantId.endsWith(this.dmpTenantNameRuleSuffix)) {
                    tenantId = tenantId.replaceFirst(this.dmpTenantNameRulePrefix, "");
                    tenantId = this.replaceLast(tenantId, this.dmpTenantNameRuleSuffix, "");
                    break;
                }
                tenantId = "";
                break;
            }
            case "hw_test": 
            case "hw_prod": {
                if (!tenantId.startsWith(this.dmpTenantNameRulePrefix) || !tenantId.endsWith(this.dmpTenantNameRuleSuffix)) break;
                tenantId = "";
                break;
            }
            default: {
                return tenantId;
            }
        }
        return tenantId;
    }

    public String replaceLast(String original, String target, String replacement) {
        if (StringUtils.isEmpty(original)) {
            return original;
        }
        int lastIndex = original.lastIndexOf(target);
        if (lastIndex != -1) {
            return original.substring(0, lastIndex) + replacement + original.substring(lastIndex + target.length());
        }
        return original;
    }

    @Override
    public List<IamOrgAspect> queryOrgAspect(IamOrgAspectDTO iamOrgAspectDTO) {
        return this.iamService.queryOrgAspect(iamOrgAspectDTO);
    }

    @Override
    public List<IamOrgAspect> queryOrgUserInOrg(IamOrgUserDTO iamOrgUserDTO) {
        return this.iamService.queryOrgUserInOrg(iamOrgUserDTO);
    }

    @Override
    public List<IamTenant> queryTenantInfo() {
        List<IamTenant> iamTenants = this.iamService.queryTenantInfo(this.appId, new Request.Options(5L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
        log.debug("invoke tenant  info response: {}", (Object)JSONUtils.toJson(iamTenants));
        if (CollectionsUtils.notEmpty(iamTenants).booleanValue()) {
            iamTenants = iamTenants.stream().filter(x -> StringUtils.isNotBlank(x.getId())).collect(Collectors.toList());
        }
        return iamTenants;
    }

    @Override
    public IamLoginUser innerLogin(LoginDTO loginDTO) {
        TokenContext.setIamAuthAppContext(IamConstant.DIGI_MIDDLEWARE_AUTH_APP);
        this.getIamLoginParam(loginDTO);
        IamLoginDTO iamLoginDTO = IamLoginDTO.builder().userId(loginDTO.getUserName()).passwordHash(loginDTO.getUserPassword()).clientEncryptPublicKey(loginDTO.getClientEncryptPublicKey()).tenantSid(loginDTO.getTenantSId()).userSId(loginDTO.getUserSId()).build();
        IamLoginUser login = this.login(iamLoginDTO);
        UserInfoContext.setContext(login.buildIamUserBase());
        log.info("user info : {}", (Object)UserInfoContext.getContext());
        return login;
    }

    @Override
    public IamLoginUser iamInternalLogin(IamLoginDTO iamLoginDTO) {
        TokenContext.setIamAuthAppContext(IamConstant.DIGI_MIDDLEWARE_AUTH_APP);
        log.debug("invoke iam internal login params:{}", (Object)JSONUtils.toJson(iamLoginDTO));
        IamLoginUser loginUser = this.iamService.internalLogin(iamLoginDTO, new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
        log.debug("invoke iam internal login response param:{}", (Object)JSONUtils.toJson(loginUser));
        TokenContext.setIamAuthUserContext(loginUser.getToken());
        loginUser.setUserType(UserType.ADMIN_USER);
        UserInfoContext.setContext(loginUser.buildIamUserBase());
        TokenContext.setIamAuthUserContext(loginUser.getToken());
        log.info("user info : {}", (Object)UserInfoContext.getContext());
        return loginUser;
    }

    private void buildLoginUserInfoByToken(IamLoginDTO iamLoginDTO, IamLoginUser loginUser) {
        List<IamTenant> iamTenants = this.queryTenantInfo();
        if (CollectionsUtils.notEmpty(iamTenants).booleanValue()) {
            IamTenant iamTenant;
            if (!ObjectUtils.isEmpty((Object)iamLoginDTO.getTenantSid())) {
                iamTenant = this.queryTenantBySid(iamLoginDTO.getTenantSid());
                if (ObjectUtils.isEmpty((Object)iamTenant)) {
                    log.error("query iam tenant By Id is empty :{}", (Object)iamLoginDTO.getTenantSid());
                    throw new BusinessException("query iam tenant by id is empty");
                }
            } else {
                Map<String, IamTenant> iamTenantMap = iamTenants.stream().collect(Collectors.toMap(IamTenant::getId, x -> x));
                iamTenant = Optional.ofNullable(iamTenantMap.get(this.dmpDefaultTenant)).orElse(iamTenants.get(0));
            }
            log.info("iam login default tenant info:{}", (Object)JSONUtils.toJson(iamTenant));
            loginUser.setTenantSid(iamTenant.getSid());
            loginUser.setTenantId(iamTenant.getId());
            loginUser.setTenantName(iamTenant.getName());
            IamTenantDTO iamTenantDTO = IamTenantDTO.builder().tenantId(loginUser.getTenantId()).tenantSid(loginUser.getTenantSid()).build();
            IamLoginUser iamLoginUser = this.identityTokenRefreshTenant(iamTenantDTO);
            loginUser.setToken(iamLoginUser.getToken());
        }
    }

    @Override
    public LoginDTO getIamLoginParam(LoginDTO loginDTO) {
        try {
            HashMap<String, String> keyMap = this.getKeyPairMap();
            if (CollectionsUtils.notEmpty(keyMap).booleanValue()) {
                String clientPublicKey = keyMap.get("publicKey");
                String privateKey = keyMap.get("privateKey");
                IamPublicKey iamPublicKey = this.iamService.queryPublicKey(new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
                String encryptPublicKey = RSAUtils.encryptByPublicKey(clientPublicKey, iamPublicKey.getPublicKey());
                IamAesKeyDTO iamAesKeyDTO = IamAesKeyDTO.builder().clientEncryptPublicKey(encryptPublicKey).build();
                IamAesPublicKy iamAesPublicKy = this.iamService.queryAesKey(iamAesKeyDTO, new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
                String aesKey = new String(RSAUtils.decryptByPrivateKey(Base64.decodeBase64((String)iamAesPublicKy.getEncryptAesKey()), privateKey));
                String passwordHash = AESUtils.aesEncryptByBase64(loginDTO.getMd5UserPassword(), aesKey);
                loginDTO.setUserPassword(passwordHash);
                loginDTO.setClientEncryptPublicKey(encryptPublicKey);
                return loginDTO;
            }
        }
        catch (Exception e) {
            log.error("generate iam login passwordHash error!e:{}", (Throwable)e);
        }
        return loginDTO;
    }

    @Override
    public Result<IamUserByToken> queryIamUserInfoByUserToken() {
        IamUserByToken iamUserByToken = null;
        try {
            iamUserByToken = this.iamService.queryIamUserInfoByUserToken();
        }
        catch (Exception e) {
            log.error("exception, e :{}", (Throwable)e);
            return Result.error(Status.AUTHENTICATION_FAIL);
        }
        log.info("invoke iam user info by user token response:{}", (Object)JSONUtils.toJson(iamUserByToken));
        return Result.success(iamUserByToken);
    }

    @Override
    public IamAnalyzeToken identityTokenAnalyze() {
        IamAnalyzeToken iamAnalyzeToken = this.iamService.identityTokenAnalyze();
        log.debug("invoke iam identity token analyze response:{}", (Object)JSONUtils.toJson(iamAnalyzeToken));
        return iamAnalyzeToken;
    }

    @Override
    public List<IamAssociationUserInRole> queryAssociationUserInRole(IamRoleDTO iamRoleDTO) {
        log.debug("invoke iam association user in role params:{}", (Object)JSONUtils.toJson(iamRoleDTO));
        List<IamAssociationUserInRole> iamAssociationUserInRoles = this.iamService.queryAssociationUserInRole(iamRoleDTO);
        log.debug("invoke iam association user in role response:{}", (Object)JSONUtils.toJson(iamAssociationUserInRoles));
        return iamAssociationUserInRoles;
    }

    @Override
    public IamPublicKey queryPublicKey() {
        TokenContext.setIamAuthUserContext("");
        IamPublicKey iamPublicKey = this.iamService.queryPublicKey(new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
        return iamPublicKey;
    }

    @Override
    public IamAesPublicKy queryAesKey(IamAesKeyDTO iamAesKeyDTO) {
        TokenContext.setIamAuthUserContext("");
        return this.iamService.queryAesKey(iamAesKeyDTO, new Request.Options(10L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS, true));
    }

    @Override
    public IamLoginUser identityTokenRefreshTenant(IamTenantDTO iamTenantDTO) {
        log.debug("invoke iam identity token refresh tenant params:{}", (Object)JSONUtils.toJson(iamTenantDTO));
        IamAuthoredUser iamAuthoredUser = this.iamService.identityTokenRefreshTenant(iamTenantDTO);
        log.debug("invoke iam identity token refresh tenant response:{}", (Object)JSONUtils.toJson(iamAuthoredUser));
        if (!ObjectUtils.isEmpty((Object)iamAuthoredUser)) {
            return iamAuthoredUser.getAuthoredUser();
        }
        return new IamLoginUser();
    }

    @Override
    public IamLoginUser identityLogout() {
        return this.iamService.identityLogout();
    }

    @Override
    public Map<Long, String> batchQueryUserIdNameMap(List<Long> userIdList) {
        Map<Long, String> map = new HashMap<Long, String>();
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userSids(userIdList).build();
        log.debug("invoke iam user info by sid params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<List<IamUserByToken>> listIamResult = this.iamService.queryUserBySids(iamTenantUserDTO);
        log.debug("iam query user by sid info :{}", (Object)JSONUtils.toJson(listIamResult));
        List<IamUserByToken> data = listIamResult.getData();
        if (CollectionsUtils.notEmpty(data).booleanValue()) {
            map = data.stream().collect(Collectors.toMap(IamUserByToken::getSid, IamUserByToken::getName));
        }
        return map;
    }

    private HashMap<String, String> getKeyPairMap() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        String privateKey = new String(Base64.encodeBase64((byte[])keyPair.getPrivate().getEncoded()));
        String publicKey = new String(Base64.encodeBase64((byte[])keyPair.getPublic().getEncoded()));
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("privateKey", privateKey);
        keyMap.put("publicKey", publicKey);
        return keyMap;
    }

    @Override
    public QueryIamAppListVo queryIamAppListVo(Integer pageSize, Integer pageNum, String content) {
        IamResult<QueryIamAppListVo> result;
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageNum", String.valueOf(pageNum));
        if (StringUtils.isNotBlank(content)) {
            params.put("content", content);
        }
        if ((result = this.iamService.queryIamAppListVo(params)).getCode() == 200) {
            return result.getData();
        }
        throw new BusinessException(Status.SEND_HTTP_REQUEST_ERROR);
    }
}

