/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import java.util.Collections;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Component
@ConditionalOnProperty(name={"spring.redis.enable"}, havingValue="true")
public class JedisUtils {
    private static final Logger log = LoggerFactory.getLogger(JedisUtils.class);
    private static final Logger logger = LoggerFactory.getLogger(JedisUtils.class);
    @Value(value="${spring.redis.host:172.16.2.191}")
    private String redisIp;
    @Value(value="${spring.redis.port:6379}")
    private Integer redisPort;
    @Value(value="${spring.redis.jedis.pool.max-active:4}")
    private Integer maxActive;
    @Value(value="${spring.redis.jedis.pool.max-idle:4}")
    private Integer maxIdle;
    @Value(value="${spring.redis.jedis.pool.min-idle:0}")
    private Integer minIdle;
    @Value(value="${spring.redis.jedis.pool.max-wait:20000}")
    private Integer maxWait;
    private JedisPool JEDIS_POOL;

    @PostConstruct
    public void initData() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.maxActive.intValue());
        config.setMaxIdle(this.maxIdle.intValue());
        config.setMinIdle(this.minIdle.intValue());
        config.setMaxWaitMillis((long)this.maxWait.intValue());
        this.JEDIS_POOL = new JedisPool((GenericObjectPoolConfig)config, this.redisIp, this.redisPort.intValue());
    }

    public Jedis getJedis() {
        return this.JEDIS_POOL.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setex(String key, Integer second, String value) {
        try {
            Jedis jedis = this.getJedis();
            try {
                jedis.setex(key, second.intValue(), value);
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("jedis setex error! key:{},value:{},e:{}", new Object[]{key, value, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String key, String value) {
        try {
            Jedis jedis = this.getJedis();
            try {
                jedis.set(key, value);
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("jedis setex error! key:{},value:{}", new Object[]{key, value, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String value = null;
        try {
            Jedis jedis = this.getJedis();
            try {
                value = jedis.get(key);
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("jedis get error! key:{},e:{}", (Object)key, (Object)e);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeys(String pattern) {
        Set keys = null;
        try {
            Jedis jedis = this.getJedis();
            try {
                keys = jedis.keys(pattern);
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("jedis getKeys error! pattern:{},e:{}", (Object)pattern, (Object)e);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hset(String key, String field, String value) {
        try {
            Jedis jedis = this.getJedis();
            try {
                jedis.hset(key, field, value);
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("jedis hset error! key:{},field:{},value:{},e:{}", new Object[]{key, field, value, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(String key, Integer second) {
        try {
            Jedis jedis = this.getJedis();
            try {
                jedis.expire(key, second.intValue());
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("jedis expire error! key:{},second:{},e:{}", new Object[]{key, second, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        String value = null;
        try {
            Jedis jedis = this.getJedis();
            try {
                value = jedis.hget(key, field);
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("jedis hget error! key:{},field:{},e:{}", new Object[]{key, field, e});
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script, Integer numkeys, String ... val) throws Exception {
        Object eval = null;
        try {
            Jedis jedis = this.getJedis();
            try {
                eval = jedis.eval(script, numkeys.intValue(), val);
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("redis excute lua script error, e:{}", (Throwable)e);
            throw new Exception("redis excute lua script error !");
        }
        return eval;
    }

    public void delKey(String ... keys) throws Exception {
        try {
            Jedis jedis = this.getJedis();
            try {
                jedis.del(keys);
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("redis delete keys error, e:{}", (Throwable)e);
            throw new Exception("redis delete keys error !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(String key, Integer second, String value) {
        Long result = 0L;
        try {
            Jedis jedis = this.getJedis();
            try {
                result = jedis.setnx(key, value);
                if (result != 1L) {
                    jedis.expire(key, second.intValue());
                }
            }
            finally {
                if (Collections.singletonList(jedis).get(0) != null) {
                    jedis.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("jedis setnx error! key:{},value:{}", new Object[]{key, value, e});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.exists(key);
            return bl;
        }
        finally {
            if (Collections.singletonList(jedis).get(0) != null) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys(String pattern) {
        Jedis jedis = this.getJedis();
        try {
            Set set = jedis.keys(pattern.concat(":*"));
            return set;
        }
        finally {
            if (Collections.singletonList(jedis).get(0) != null) {
                jedis.close();
            }
        }
    }
}

