/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.es.httpclient;

import com.digiwin.commons.processor.es.httpclient.HttpIndicesClient;
import com.digiwin.commons.processor.es.httpclient.request.HttpDeleteRequest;
import com.digiwin.commons.processor.es.httpclient.request.HttpInsertRequest;
import com.digiwin.commons.processor.es.httpclient.request.HttpSearchRequest;
import com.digiwin.commons.processor.es.httpclient.request.HttpStatsRequest;
import com.digiwin.commons.processor.es.httpclient.request.HttpUpdateRequest;
import com.digiwin.commons.utils.HttpUtils;
import com.digiwin.commons.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOprationEsClient {
    private static final Logger log = LoggerFactory.getLogger(HttpOprationEsClient.class);
    private String address;
    private String httpUrl;
    private String user;
    private String password;
    private String port;
    private String httpBasicAccount;
    private HttpIndicesClient httpIndicesClient;

    public final HttpIndicesClient indices() {
        return this.httpIndicesClient;
    }

    public String bulkInsert(HttpInsertRequest httpInsertRequest) {
        Map<String, String> data = httpInsertRequest.getDataMap();
        String url = String.format("%s/%s/%s/_bulk", this.httpUrl, httpInsertRequest.getIndex(), httpInsertRequest.getType());
        url = this.getPipelineAndRoutingParamUrl(url, httpInsertRequest.getPipeline(), httpInsertRequest.getRouting());
        StringBuilder sb = new StringBuilder();
        data.entrySet().forEach(i -> {
            sb.append(String.format("{\"%s\":{\"_id\": \"%s\"}}", "index", i.getKey()));
            sb.append("\n");
            sb.append((String)i.getValue());
            sb.append("\n");
        });
        return HttpUtils.post(url, String.valueOf(sb), null, this.getHttpEsHeader());
    }

    public String bulkDeleteById(HttpDeleteRequest httpDeleteRequest) {
        String url = String.format("%s/%s/%s/_bulk", this.httpUrl, httpDeleteRequest.getIndex(), httpDeleteRequest.getType());
        url = this.getPipelineAndRoutingParamUrl(url, null, httpDeleteRequest.getRouting());
        StringBuilder sb = new StringBuilder();
        httpDeleteRequest.getDataList().stream().forEach(i -> {
            sb.append(String.format("{\"%s\":{\"_id\": \"%s\"}}", "delete", i));
            sb.append("\n");
        });
        return HttpUtils.post(url, String.valueOf(sb), null, this.getHttpEsHeader());
    }

    public String docDeleteByQuery(HttpSearchRequest httpSearchRequest) {
        String url = String.format("%s/%s/_delete_by_query", this.httpUrl, httpSearchRequest.getIndex());
        return HttpUtils.post(url, httpSearchRequest.getQueryParam(), null, this.getHttpEsHeader());
    }

    public String bulkUpdateById(HttpUpdateRequest httpUpdateRequest) {
        String url = String.format("%s/%s/%s/_bulk", this.httpUrl, httpUpdateRequest.getIndex(), httpUpdateRequest.getType());
        url = this.getPipelineAndRoutingParamUrl(url, null, httpUpdateRequest.getRouting());
        StringBuilder sb = new StringBuilder();
        httpUpdateRequest.getDataMap().entrySet().forEach(i -> {
            sb.append(String.format("{\"%s\":{\"_id\": \"%s\"}}", "update", i.getKey()));
            sb.append("\n");
            sb.append(String.format("{\"doc\":%s}", i.getValue()));
            sb.append("\n");
        });
        return HttpUtils.post(url, String.valueOf(sb), null, this.getHttpEsHeader());
    }

    public String query(HttpSearchRequest httpSearchRequest) {
        String url = String.format("%s/%s/_search", this.httpUrl, httpSearchRequest.getIndex(), httpSearchRequest.getType());
        return HttpUtils.get(url, httpSearchRequest.getQueryParam(), null, this.getHttpEsHeader());
    }

    public String queryEsIndexStorageInfo(HttpStatsRequest httpStatsRequest) {
        String url = String.format("%s/%s/_stats", this.httpUrl, httpStatsRequest.getIndex());
        return HttpUtils.get(url, null, null, this.getHttpEsHeader());
    }

    private String getPipelineAndRoutingParamUrl(String url, String pipeline, String routing) {
        if (StringUtils.isNotBlank(pipeline)) {
            url = url.contains("?") ? url.concat("&") : url.concat("?");
            url = url.concat("pipeline").concat("=").concat(pipeline);
        }
        if (StringUtils.isNotBlank(routing)) {
            url = url.contains("?") ? url.concat("&") : url.concat("?");
            url = url.concat("routing").concat("=").concat(routing);
        }
        return url;
    }

    public Map<String, String> getHttpEsHeader() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", this.httpBasicAccount);
        return headerMap;
    }

    public String getAddress() {
        return this.address;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public String getHttpBasicAccount() {
        return this.httpBasicAccount;
    }

    public HttpIndicesClient getHttpIndicesClient() {
        return this.httpIndicesClient;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setHttpBasicAccount(String httpBasicAccount) {
        this.httpBasicAccount = httpBasicAccount;
    }

    public void setHttpIndicesClient(HttpIndicesClient httpIndicesClient) {
        this.httpIndicesClient = httpIndicesClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpOprationEsClient)) {
            return false;
        }
        HttpOprationEsClient other = (HttpOprationEsClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$httpUrl = this.getHttpUrl();
        String other$httpUrl = other.getHttpUrl();
        if (this$httpUrl == null ? other$httpUrl != null : !this$httpUrl.equals(other$httpUrl)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$httpBasicAccount = this.getHttpBasicAccount();
        String other$httpBasicAccount = other.getHttpBasicAccount();
        if (this$httpBasicAccount == null ? other$httpBasicAccount != null : !this$httpBasicAccount.equals(other$httpBasicAccount)) {
            return false;
        }
        HttpIndicesClient this$httpIndicesClient = this.getHttpIndicesClient();
        HttpIndicesClient other$httpIndicesClient = other.getHttpIndicesClient();
        return !(this$httpIndicesClient == null ? other$httpIndicesClient != null : !this$httpIndicesClient.equals(other$httpIndicesClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpOprationEsClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $httpUrl = this.getHttpUrl();
        result = result * 59 + ($httpUrl == null ? 43 : $httpUrl.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $httpBasicAccount = this.getHttpBasicAccount();
        result = result * 59 + ($httpBasicAccount == null ? 43 : $httpBasicAccount.hashCode());
        HttpIndicesClient $httpIndicesClient = this.getHttpIndicesClient();
        result = result * 59 + ($httpIndicesClient == null ? 43 : $httpIndicesClient.hashCode());
        return result;
    }

    public String toString() {
        return "HttpOprationEsClient(address=" + this.getAddress() + ", httpUrl=" + this.getHttpUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", port=" + this.getPort() + ", httpBasicAccount=" + this.getHttpBasicAccount() + ", httpIndicesClient=" + this.getHttpIndicesClient() + ")";
    }
}

