/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.service.impl;

import com.digiwin.commons.entity.dto.translation.TranslateDTO;
import com.digiwin.commons.feign.client.TranslationService;
import com.digiwin.commons.service.TranslationBusinessService;
import com.digiwin.commons.utils.JSONUtils;
import feign.Request;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"translation.feign.enable"}, havingValue="true")
public class TranslationBusinessServiceImpl
implements TranslationBusinessService {
    private static final Logger log = LoggerFactory.getLogger(TranslationBusinessServiceImpl.class);
    @Autowired
    private TranslationService translationService;
    @Value(value="${deploy.independent:false}")
    private Boolean groundDeploy;

    @Override
    public String translate(String translate) {
        if (!this.groundDeploy.booleanValue()) {
            return translate;
        }
        TranslateDTO translateDTO = JSONUtils.parseObject(translate, TranslateDTO.class);
        String result = this.translationService.translate(translateDTO, new Request.Options(10L, TimeUnit.SECONDS, 100L, TimeUnit.SECONDS, true));
        log.info("invoke query translate result:{}", (Object)JSONUtils.toJson(result));
        return result;
    }
}

