/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils
extends DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    public static String currentParse(String parse) {
        SimpleDateFormat sdf = new SimpleDateFormat(parse);
        String format = sdf.format(DateUtils.current());
        return format;
    }

    public static List<String> getCurrentDatePreDate(Integer preDay, String format) {
        DateTime currentDateTime = DateUtils.date();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = preDay - 1; i >= 0; --i) {
            DateTime date = DateUtil.offsetDay((Date)currentDateTime, (int)(-i));
            String formattedDate = DateUtil.format((Date)date, (String)format);
            list.add(formattedDate);
        }
        return list;
    }

    public static Long getCurrTimeStamp() {
        return new Date().getTime() / 1000L;
    }

    public static String getPreHourDate(String currentDate, Integer hourCount, String formatPattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatPattern);
        String newDateString = "";
        try {
            Date date = sdf.parse(currentDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(10, hourCount);
            Date newDate = calendar.getTime();
            newDateString = sdf.format(newDate);
        }
        catch (Exception e) {
            log.error("date format error!e:{}", (Throwable)e);
        }
        return newDateString;
    }

    public static List<String> getTimeHourList(String startTime, String endTime, String formatPattern, String returnFormatPattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
        LocalDateTime start = LocalDateTime.parse(startTime, formatter);
        LocalDateTime end = LocalDateTime.parse(endTime, formatter);
        long hoursBetween = ChronoUnit.HOURS.between(start, end) + 1L;
        ArrayList<String> hourList = new ArrayList<String>();
        for (long i = 0L; i < hoursBetween; ++i) {
            LocalDateTime hour = start.plusHours(i);
            hourList.add(hour.format(DateTimeFormatter.ofPattern(returnFormatPattern)));
        }
        return hourList;
    }
}

