/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import org.springframework.util.ObjectUtils;

public enum RelationTagModule {
    DAAS_API(0, "api"),
    DS_TABLE(1, "table"),
    DS_DATA_QUALITY(2, "data_quality");

    private final int code;
    private final String desc;

    private RelationTagModule(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (RelationTagModule ty : RelationTagModule.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static RelationTagModule of(String desc) {
        for (RelationTagModule ty : RelationTagModule.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.getDesc(), (Object)desc)) continue;
            return ty;
        }
        return null;
    }

    public static Integer of(int type) {
        for (RelationTagModule ty : RelationTagModule.values()) {
            if (ty.getCode() != type) continue;
            return ty.getCode();
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

