/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.handler;

import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.entity.vo.dap.TDapTableVO;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.handler.BaseDBHandler;
import com.digiwin.commons.utils.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class GreenplumDBHandler
implements BaseDBHandler {
    private void concatSchemaToTableName(TDapTableVO vo) {
        Optional.ofNullable(vo.getCatalogue()).filter(StringUtils::isNotBlank).filter(schema -> !ObjectUtils.nullSafeEquals((Object)"public", (Object)schema)).ifPresent(i -> vo.setCode(i + "." + vo.getCode()));
    }

    @Override
    public List<String> queryTableListInDB(String param, String schema, String searchVal, Integer limit, Integer offset) {
        log.info(" {} handler execute query table list , param [{}] ", (Object)this.type().getDesc(), (Object)param);
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> tableList = new ArrayList();
        String sql = "select tablename tableName from pg_tables where schemaname not IN('gp_toolkit','information_schema','pg_aoseg','pg_bitmapindex','pg_catalog','pg_toast')";
        try (Connection con = this.getConnection(this.type(), param);
             ResultSet rs = con.createStatement().executeQuery(sql);){
            while (rs.next()) {
                String tableName = rs.getString("tableName");
                tables.add(tableName);
            }
            tableList = this.queryFilterTableNames(tables, searchVal, limit, offset);
            log.info(" greenplum handler execute query table list , tables : {} ", tableList);
        }
        catch (SQLException e) {
            log.info(" query table list error , e : {} ", (Throwable)e);
            throw new BusinessException(" query table list error :{0}", e);
        }
        return tableList;
    }

    @Override
    public DbType type() {
        return DbType.GREENPLUM;
    }
}

