/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.datasource;

import com.digiwin.commons.datasource.BaseDataSource;
import com.digiwin.commons.entity.enums.DbType;
import java.sql.Connection;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class ImpalaDataSource
extends BaseDataSource {
    private String memory;

    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    @Override
    public String driverClassSelector() {
        return "com.cloudera.impala.jdbc41.Driver";
    }

    @Override
    public DbType dbTypeSelector() {
        return DbType.IMPALA;
    }

    @Override
    public String getJdbcUrl() {
        StringBuilder jdbcUrl = new StringBuilder(this.getAddress());
        this.appendDatabase(jdbcUrl);
        this.appendOtherInfo(jdbcUrl);
        return jdbcUrl.toString();
    }

    private void appendOtherInfo(StringBuilder jdbcUrl) {
        String memory = this.getMemory();
        Optional.ofNullable(this.getMemory()).filter(i -> StringUtils.isNotBlank((String)i)).ifPresent(i -> jdbcUrl.append(";mem_limit=").append(memory));
        jdbcUrl.append(";AuthMech=0");
    }

    @Override
    public Connection getConnection() throws Exception {
        return super.getConnection();
    }

    public static enum ImpalaAuthEnum {
        NO_AUTH("No Authentication", 0),
        KERBEROS("Kerberos", 1),
        USER_NAME("User Name", 2),
        USER_NAME_AND_PASSWORD("User Name and Password", 3);

        private final String name;
        private final Integer code;

        private ImpalaAuthEnum(String name, Integer code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public Integer getCode() {
            return this.code;
        }
    }
}

