/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.startup;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.iam.IamUserCache;
import com.digiwin.commons.service.IamBusinessService;
import com.digiwin.commons.utils.JedisUtils;
import com.digiwin.commons.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
@Transactional(rollbackFor={Exception.class})
@ConditionalOnProperty(name={"iam.feign.enable"}, havingValue="true")
public class TDapIamUserCacheService {
    private static final Logger log = LoggerFactory.getLogger(TDapIamUserCacheService.class);
    @Autowired
    private IamBusinessService iamBusinessService;
    @Autowired
    private JedisUtils jedisUtils;

    public IamUserCache selectByCodeOfNullBuild(Long sId) {
        String userRedisPrefix = this.getUserRedisPrefix(sId);
        String userInfoJson = this.jedisUtils.get(userRedisPrefix);
        if (StringUtils.isNotBlank(userInfoJson)) {
            IamUserCache iamUserCache = (IamUserCache)JSONObject.parseObject((String)userInfoJson, IamUserCache.class);
            return Optional.ofNullable(iamUserCache).orElse(IamUserCache.builder().build());
        }
        if (StringUtils.isEmpty(TokenContext.getIamAuthUserContext())) {
            return IamUserCache.builder().build();
        }
        List<UserInfo> userInfoList = this.queryIamTenantAuthUsersByPage(Collections.singletonList(sId));
        if (CollectionUtils.isEmpty(userInfoList)) {
            log.error("iam Tenant User is empty");
            IamUserCache iamUserCache = IamUserCache.builder().sid(sId).name("").build();
            return iamUserCache;
        }
        IamUserCache iamUserCache = IamUserCache.builder().sid(userInfoList.get(0).getSid()).name(userInfoList.get(0).getUserName()).build();
        int expireTime = ThreadLocalRandom.current().nextInt(0, 1000);
        this.jedisUtils.setex(userRedisPrefix, 3600 + expireTime, JSONObject.toJSONString((Object)iamUserCache));
        return iamUserCache;
    }

    private String getUserRedisPrefix(Long sid) {
        return String.format("iam_user_info_%s", sid);
    }

    private List<UserInfo> queryIamTenantAuthUsersByPage(List<Long> sidList) {
        return this.iamBusinessService.queryBatchUserInfoBySidList(sidList);
    }
}

