/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.entity.model.ds.Property;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.handler.BaseDBHandler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImpalaDBHandler
implements BaseDBHandler {
    private static final Logger log = LoggerFactory.getLogger(ImpalaDBHandler.class);
    private final DbType dbType = DbType.IMPALA;

    @Override
    public List<String> queryTableListInDB(String param, String schema, String searchVal, Integer limit, Integer offset) {
        log.info(" impala handler execute query table list , param [{}] ", (Object)param);
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> tableList = new ArrayList();
        JSONObject jsonObject = JSON.parseObject((String)param);
        String database = jsonObject.getString("database");
        try (Connection con = this.getConnection(this.dbType, param);
             ResultSet rs = con.getMetaData().getTables(null, database, "%", new String[]{"TABLE"});){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String cat = rs.getString("TABLE_CAT");
                String shem = rs.getString("TABLE_SCHEM");
                if (!shem.equals(database)) continue;
                tables.add(tableName);
            }
            tableList = this.queryFilterTableNames(tables, searchVal, limit, offset);
            log.info(" impala handler execute query table list , tables : {} ", tableList);
        }
        catch (SQLException e) {
            log.info(" query table list error , e : {} ", (Throwable)e);
            throw new BusinessException(" query table list error ");
        }
        return tableList;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Property> getPartitionFieldsForTable(String param, String tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSet getDbColumnResultSet(String param, String schema, String dbName, String tableName) throws Exception {
        Connection con = this.getConnection(this.type(), param);
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet resultSet = metaData.getColumns(null, dbName, tableName, null);
        return resultSet;
    }

    @Override
    public DbType type() {
        return DbType.IMPALA;
    }

    @Autowired
    public ImpalaDBHandler() {
    }
}

