/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import org.springframework.util.ObjectUtils;

public enum AccessType {
    SELECT(1, "select"),
    JOIN(2, "join");

    @EnumValue
    private final int code;
    private final String desc;

    private AccessType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (AccessType ty : AccessType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static AccessType of(String desc) {
        for (AccessType ty : AccessType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.getDesc(), (Object)desc)) continue;
            return ty;
        }
        return null;
    }

    public static Integer of(int type) {
        for (AccessType ty : AccessType.values()) {
            if (ty.getCode() != type) continue;
            return ty.getCode();
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

