/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.security;

import cn.hutool.core.lang.Pair;
import cn.hutool.crypto.SmUtil;
import com.digiwin.commons.context.AesSecretKeyContext;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.enums.EncryptTemplateType;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.security.EncryptConfig;
import com.digiwin.commons.entity.model.security.TDsDataSecurityRuleConfig;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.factory.BeanFactoryContext;
import com.digiwin.commons.utils.AesUtils;
import com.digiwin.commons.utils.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.ObjectUtils;

public class EncryptRule {
    public static final Logger logger = LoggerFactory.getLogger(EncryptRule.class);
    private static BeanFactory beanFactory;

    public static String decryptFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData, String aesKey) {
        return AesUtils.decrypt(originalData, aesKey);
    }

    public static String encryptFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData, String aesKey) {
        EncryptConfig config = (EncryptConfig)ruleConfig;
        EncryptTemplateType encryptTemplateType = config.getEncryptTemplateType();
        switch (encryptTemplateType) {
            case MD5_RULE: {
                return EncryptRule.md5Hex(originalData + config.getSalt());
            }
            case SHA256_RULE: {
                return EncryptRule.sha256Hex(originalData + config.getSalt());
            }
            case SM3_RULE: {
                return SmUtil.sm3((String)(originalData + config.getSalt()));
            }
            case AES_RULE: {
                return AesUtils.encrypt(originalData, aesKey);
            }
        }
        return originalData;
    }

    public static String decryptFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData) {
        String aesKey = EncryptRule.getAesKeyDecrypt(ruleConfig.getAesSecretKey());
        return AesUtils.decrypt(originalData, aesKey);
    }

    public static String encryptFunction(TDsDataSecurityRuleConfig ruleConfig, String originalData) {
        EncryptConfig config = (EncryptConfig)ruleConfig;
        EncryptTemplateType encryptTemplateType = config.getEncryptTemplateType();
        switch (encryptTemplateType) {
            case MD5_RULE: {
                return EncryptRule.md5Hex(originalData + config.getSalt());
            }
            case SHA256_RULE: {
                return EncryptRule.sha256Hex(originalData + config.getSalt());
            }
            case SM3_RULE: {
                return SmUtil.sm3((String)(originalData + config.getSalt()));
            }
            case AES_RULE: {
                String aesKey = EncryptRule.getAesKeyEncrypt();
                return AesUtils.encrypt(originalData, aesKey);
            }
        }
        return originalData;
    }

    public static String getAesKeyEncrypt() {
        UserInfo userInfo = UserInfoContext.getContext();
        String aesKey = (String)EncryptRule.getAesKeyPair(userInfo.getTenantId()).getValue();
        if (StringUtils.isBlank(aesKey)) {
            throw new BusinessException(Status.AES_SECRET_KEY_IS_EMPTY_ERROR);
        }
        return aesKey;
    }

    public static String getAesKeyDecrypt(String aesSecretKey) {
        UserInfo userInfo = UserInfoContext.getContext();
        AesSecretKeyContext aesSecretKeyContext = BeanFactoryContext.findBeanByClass(AesSecretKeyContext.class);
        aesSecretKeyContext.initAesSecretKey(userInfo.getTenantId());
        String aesKey = EncryptRule.getAesKeyDecrypt(userInfo.getTenantId(), aesSecretKey);
        if (StringUtils.isBlank(aesKey)) {
            throw new BusinessException(Status.AES_SECRET_KEY_IS_EMPTY_ERROR);
        }
        return aesKey;
    }

    public static String md5Hex(String originalData) {
        return DigestUtils.md5Hex((String)originalData);
    }

    public static String sha256Hex(String originalData) {
        return DigestUtils.sha256Hex((String)originalData);
    }

    public static String getAesKeyDecrypt(Long tenantId, String secretKey) {
        Pair<String, String> secretKeyPair = AesSecretKeyContext.getAesKeyPair(tenantId);
        if (ObjectUtils.isEmpty(secretKeyPair)) {
            throw new BusinessException(Status.AES_SECRET_KEY_BY_TENANT_IS_EMPTY_ERROR);
        }
        String key = (String)secretKeyPair.getKey();
        if (!ObjectUtils.nullSafeEquals((Object)key, (Object)secretKey)) {
            throw new BusinessException(Status.AES_SECRET_KEY_IS_INVALID_ERROR);
        }
        return (String)secretKeyPair.getValue();
    }

    private static Pair<String, String> getAesKeyPair(Long tenantId) {
        Pair<String, String> secretKeyPair = AesSecretKeyContext.getAesKeyPair(tenantId);
        if (!ObjectUtils.isEmpty(secretKeyPair)) {
            return secretKeyPair;
        }
        AesSecretKeyContext aesSecretKeyBean = BeanFactoryContext.findBeanByClass(AesSecretKeyContext.class);
        aesSecretKeyBean.initAesSecretKey(tenantId);
        secretKeyPair = AesSecretKeyContext.getAesKeyPair(tenantId);
        if (ObjectUtils.isEmpty(secretKeyPair)) {
            throw new BusinessException(Status.AES_SECRET_KEY_BY_TENANT_IS_EMPTY_ERROR);
        }
        return secretKeyPair;
    }
}

