/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.model.datasource;

import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.entity.model.datasource.BaseDataSource;
import com.digiwin.commons.utils.HiveConfUtils;
import com.digiwin.commons.utils.StringUtils;
import java.sql.Connection;

public class HiveDataSource
extends BaseDataSource {
    @Override
    public String driverClassSelector() {
        return "org.apache.hive.jdbc.HiveDriver";
    }

    @Override
    public DbType dbTypeSelector() {
        return DbType.HIVE;
    }

    @Override
    protected String filterOther(String otherParams) {
        String[] otherArray;
        if (StringUtils.isBlank(otherParams)) {
            return "";
        }
        StringBuilder hiveConfListSb = new StringBuilder();
        hiveConfListSb.append("?");
        StringBuilder sessionVarListSb = new StringBuilder();
        for (String conf : otherArray = otherParams.split(";", -1)) {
            if (HiveConfUtils.isHiveConfVar(conf)) {
                hiveConfListSb.append(conf).append(";");
                continue;
            }
            sessionVarListSb.append(conf).append(";");
        }
        if (sessionVarListSb.length() > 0) {
            sessionVarListSb.deleteCharAt(sessionVarListSb.length() - 1);
        }
        if (hiveConfListSb.length() > 0) {
            hiveConfListSb.deleteCharAt(hiveConfListSb.length() - 1);
        }
        return sessionVarListSb.toString() + hiveConfListSb.toString();
    }

    @Override
    public Connection getConnection() throws Exception {
        return super.getConnection();
    }
}

