/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.db;

import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.processor.db.DbBaseProcessor;
import com.digiwin.commons.processor.db.MysqlDbProcessor;
import com.digiwin.commons.processor.db.OracleDbProcessor;
import com.digiwin.commons.processor.db.SqlServerDbProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(DbProcessorFactory.class);

    public static DbBaseProcessor getDbProcessor(DbType dbType) {
        switch (dbType) {
            case MYSQL: {
                return new MysqlDbProcessor();
            }
            case ORACLE: {
                return new OracleDbProcessor();
            }
            case SQLSERVER: {
                return new SqlServerDbProcessor();
            }
        }
        log.error("unsupport db type: {}", (Object)dbType.getDesc());
        throw new RuntimeException("not support db type");
    }
}

