/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class CollectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(CollectionUtils.class);
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    private CollectionUtils() {
        throw new IllegalStateException("CollectionUtils class");
    }

    public static <T> Collection<T> subtract(Set<T> a, Set<T> b) {
        return org.apache.commons.collections4.CollectionUtils.subtract(a, b);
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmptyMap(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static Map<String, String> stringToMap(String str, String separator) {
        return CollectionUtils.stringToMap(str, separator, "");
    }

    public static Map<String, String> stringToMap(String str, String separator, String keyPrefix) {
        HashMap<String, String> emptyMap = new HashMap<String, String>(0);
        if (StringUtils.isEmpty((String)str)) {
            return emptyMap;
        }
        if (StringUtils.isEmpty((String)separator)) {
            return emptyMap;
        }
        String[] strings = str.split(separator);
        int initialCapacity = (int)((float)strings.length / 0.75f) + 1;
        HashMap<String, String> map = new HashMap<String, String>(initialCapacity);
        for (int i = 0; i < strings.length; ++i) {
            String[] strArray = strings[i].split("=");
            if (strArray.length != 2) {
                return emptyMap;
            }
            if (StringUtils.isEmpty((String)keyPrefix)) {
                map.put(strArray[0], strArray[1]);
                continue;
            }
            map.put(keyPrefix + strArray[0], strArray[1]);
        }
        return map;
    }

    public static boolean equalLists(Collection<?> a, Collection<?> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return CollectionUtils.isEqualCollection(a, b);
    }

    public static boolean isEqualCollection(Collection<?> a, Collection<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        CardinalityHelper helper = new CardinalityHelper(a, b);
        if (helper.cardinalityA.size() != helper.cardinalityB.size()) {
            return false;
        }
        for (Object obj : helper.cardinalityA.keySet()) {
            if (helper.freqA(obj) == helper.freqB(obj)) continue;
            return false;
        }
        return true;
    }

    public static <O> Map<O, Integer> getCardinalityMap(Iterable<? extends O> coll) {
        HashMap<O, Integer> count = new HashMap<O, Integer>();
        for (O obj : coll) {
            count.put(obj, count.getOrDefault(obj, 0) + 1);
        }
        return count;
    }

    public static List subList(List result, Integer pageNumber, Integer pageSize) {
        int endIndex;
        if (CollectionUtils.isEmpty(result)) {
            return result;
        }
        if (ObjectUtils.isEmpty((Object)pageNumber) || ObjectUtils.isEmpty((Object)pageSize)) {
            return result;
        }
        int startIndex = (pageNumber - 1) * pageSize;
        if (startIndex > (endIndex = Math.min(startIndex + pageSize, result.size()))) {
            return new ArrayList();
        }
        logger.info("sub list by page : start {} end {}", (Object)startIndex, (Object)endIndex);
        return result.subList(startIndex, endIndex);
    }

    private static class CardinalityHelper<O> {
        final Map<O, Integer> cardinalityA;
        final Map<O, Integer> cardinalityB;

        public CardinalityHelper(Iterable<? extends O> a, Iterable<? extends O> b) {
            this.cardinalityA = CollectionUtils.getCardinalityMap(a);
            this.cardinalityB = CollectionUtils.getCardinalityMap(b);
        }

        public int freqA(Object obj) {
            return this.getFreq(obj, this.cardinalityA);
        }

        public int freqB(Object obj) {
            return this.getFreq(obj, this.cardinalityB);
        }

        private int getFreq(Object obj, Map<?, Integer> freqMap) {
            Integer count = freqMap.get(obj);
            if (count != null) {
                return count;
            }
            return 0;
        }
    }
}

