/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.feign.conf;

import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.feign.conf.IamFeignErrorDecoder;
import com.digiwin.commons.utils.StringUtils;
import feign.RequestInterceptor;
import feign.codec.ErrorDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.i18n.LocaleContextHolder;

public class IamFeignConfig {
    private static final Logger log = LoggerFactory.getLogger(IamFeignConfig.class);

    @Bean
    public RequestInterceptor iamRequestInterceptor() {
        return template -> {
            String language;
            template.header("digi-middleware-auth-app", new String[]{TokenContext.getIamAuthAppContext()});
            String iamAuthUserContext = TokenContext.getIamAuthUserContext();
            if (!StringUtils.isEmpty(iamAuthUserContext)) {
                template.header("digi-middleware-auth-user", new String[]{iamAuthUserContext});
            }
            if (StringUtils.isNotBlank(language = LocaleContextHolder.getLocale().toLanguageTag())) {
                template.header("Language", new String[]{language});
            }
        };
    }

    @Bean
    public ErrorDecoder iamFeignErrorDecoder() {
        return new IamFeignErrorDecoder();
    }
}

