/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.feign.conf;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.exceptions.IamException;
import com.digiwin.commons.utils.JSONUtils;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamFeignErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(IamFeignErrorDecoder.class);

    public Exception decode(String s, Response response) {
        int status;
        block6: {
            status = response.status();
            try {
                if (response.body() == null) break block6;
                String body = Util.toString((Reader)response.body().asReader(StandardCharsets.UTF_8));
                log.error("IAM Service Error: {}, {}", (Object)status, (Object)body);
                String errorMessage = body;
                if (status == 500) {
                    try {
                        JSONObject jsonObject = JSONUtils.parseObject(body);
                        if (jsonObject.containsKey((Object)"errorMessage")) {
                            errorMessage = jsonObject.getString("errorMessage");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return new IamException(status, errorMessage);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new IamException(status, "IAM Service Error");
    }
}

