/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.model.iam;

import com.digiwin.commons.entity.constant.IamConstant;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.exceptions.BusinessException;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamResult<T> {
    private static final Logger log = LoggerFactory.getLogger(IamResult.class);
    private Integer code;
    private boolean success;
    private String message;
    private T data;

    public boolean isSuccess() {
        return IamConstant.SUCCESS_CODE.equals(this.code);
    }

    @JsonCreator
    public IamResult(Integer code, boolean success, String message, T data) {
        if (!IamConstant.SUCCESS_CODE.equals(code)) {
            log.error("invoke iam api error!msg:{}", (Object)message);
            throw new BusinessException(Status.INVOKE_IAM_API_ERROR);
        }
        this.code = code;
        this.success = success;
        this.message = message;
        this.data = data;
    }

    public static <T> IamResultBuilder<T> builder() {
        return new IamResultBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IamResult)) {
            return false;
        }
        IamResult other = (IamResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IamResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "IamResult(code=" + this.getCode() + ", success=" + this.isSuccess() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public IamResult() {
    }

    public static class IamResultBuilder<T> {
        private Integer code;
        private boolean success;
        private String message;
        private T data;

        IamResultBuilder() {
        }

        public IamResultBuilder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public IamResultBuilder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public IamResultBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public IamResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public IamResult<T> build() {
            return new IamResult<T>(this.code, this.success, this.message, this.data);
        }

        public String toString() {
            return "IamResult.IamResultBuilder(code=" + this.code + ", success=" + this.success + ", message=" + this.message + ", data=" + this.data + ")";
        }
    }
}

